/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.threetag.threecore.capability.CapabilityAbilityContainer;

public class RemoveAbilityContainerMessage {
    private final int entityID;
    private final ResourceLocation id;

    public RemoveAbilityContainerMessage(int entityID, ResourceLocation id) {
        this.entityID = entityID;
        this.id = id;
    }

    public RemoveAbilityContainerMessage(PacketBuffer buffer) {
        this.entityID = buffer.readInt();
        this.id = buffer.func_192575_l();
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.entityID);
        buffer.func_192572_a(this.id);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
            if (entity instanceof LivingEntity) {
                entity.getCapability(CapabilityAbilityContainer.MULTI_ABILITY_CONTAINER).ifPresent(multiContainer -> multiContainer.removeContainer((LivingEntity)entity, this.id));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

