/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.container.IAbilityContainer;

public class RemoveAbilityMessage {
    public int entityID;
    public ResourceLocation containerId;
    public String abilityId;

    public RemoveAbilityMessage(int entityID, ResourceLocation containerId, String abilityId) {
        this.entityID = entityID;
        this.containerId = containerId;
        this.abilityId = abilityId;
    }

    public RemoveAbilityMessage(PacketBuffer buffer) {
        this.entityID = buffer.readInt();
        this.containerId = new ResourceLocation(buffer.func_150789_c(64));
        this.abilityId = buffer.func_150789_c(32);
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.entityID);
        buffer.func_180714_a(this.containerId.toString());
        buffer.func_180714_a(this.abilityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IAbilityContainer container;
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
            if (entity != null && entity instanceof LivingEntity && (container = AbilityHelper.getAbilityContainerFromId((LivingEntity)entity, this.containerId)) != null) {
                container.removeAbility((LivingEntity)entity, this.abilityId);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

