/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.network;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.container.IAbilityContainer;
import net.threetag.threecore.util.threedata.ThreeData;

public class SetAbilityKeybindMessage {
    public ResourceLocation containerId;
    public String abilityId;
    public int keyBind;

    public SetAbilityKeybindMessage(ResourceLocation containerId, String abilityId, int keyBind) {
        this.containerId = containerId;
        this.abilityId = abilityId;
        this.keyBind = keyBind;
    }

    public SetAbilityKeybindMessage(PacketBuffer buffer) {
        this.containerId = new ResourceLocation(buffer.func_150789_c(64));
        this.abilityId = buffer.func_150789_c(32);
        this.keyBind = buffer.readInt();
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_180714_a(this.containerId.toString());
        buffer.func_180714_a(this.abilityId);
        buffer.writeInt(this.keyBind);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Ability ability;
            IAbilityContainer container;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (container = AbilityHelper.getAbilityContainerFromId((LivingEntity)player, this.containerId)) != null && (ability = (Ability)container.getAbilityMap().get(this.abilityId)) != null) {
                ability.getDataManager().set((ThreeData)Ability.KEYBIND, (Object)this.keyBind);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

