/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.accessoires.Accessoire;
import net.threetag.threecore.accessoires.AccessoireSlot;
import net.threetag.threecore.capability.CapabilityAccessoires;
import net.threetag.threecore.client.gui.AccessoireScreen;

public class SyncAccessoiresMessage {
    public int entityId;
    public Map<AccessoireSlot, Collection<Accessoire>> accessoires;

    public SyncAccessoiresMessage(int entityId, Map<AccessoireSlot, Collection<Accessoire>> accessoires) {
        this.entityId = entityId;
        this.accessoires = accessoires;
    }

    public SyncAccessoiresMessage(PacketBuffer buf) {
        this.entityId = buf.readInt();
        int amount = buf.readInt();
        this.accessoires = new HashMap<AccessoireSlot, Collection<Accessoire>>();
        for (int i = 0; i < amount; ++i) {
            AccessoireSlot slot = AccessoireSlot.getSlotByName(buf.func_218666_n());
            ArrayList<IForgeRegistryEntry> accessoireList = new ArrayList<IForgeRegistryEntry>();
            int slotAmount = buf.readInt();
            for (int j = 0; j < slotAmount; ++j) {
                accessoireList.add(buf.readRegistryIdSafe(Accessoire.class));
            }
            this.accessoires.put(slot, accessoireList);
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.accessoires.size());
        this.accessoires.forEach((slot, accessoireList) -> {
            buf.func_180714_a(slot.getName());
            buf.writeInt(accessoireList.size());
            for (Accessoire accessoire : accessoireList) {
                buf.writeRegistryId((IForgeRegistryEntry)accessoire);
            }
        });
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId);
            if (entity instanceof AbstractClientPlayerEntity) {
                entity.getCapability(CapabilityAccessoires.ACCESSOIRES).ifPresent(k -> {
                    k.clear((PlayerEntity)entity);
                    this.accessoires.forEach((slot, accessoireList) -> {
                        for (Accessoire accessoire : accessoireList) {
                            k.enable((AccessoireSlot)slot, accessoire, (PlayerEntity)entity);
                        }
                    });
                    if (Minecraft.func_71410_x().field_71462_r instanceof AccessoireScreen) {
                        ((AccessoireScreen)Minecraft.func_71410_x().field_71462_r).accessoireList.refreshList();
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

