/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.network;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.accessoires.Accessoire;
import net.threetag.threecore.accessoires.AccessoireSlot;
import net.threetag.threecore.capability.CapabilityAccessoires;
import net.threetag.threecore.capability.IAccessoireHolder;

public class ToggleAccessoireMessage {
    public AccessoireSlot slot;
    public Accessoire accessoire;

    public ToggleAccessoireMessage(AccessoireSlot slot, Accessoire accessoire) {
        this.slot = slot;
        this.accessoire = accessoire;
    }

    public ToggleAccessoireMessage(PacketBuffer packetBuffer) {
        this.slot = AccessoireSlot.getSlotByName(packetBuffer.func_150789_c(Short.MAX_VALUE));
        this.accessoire = (Accessoire)packetBuffer.readRegistryIdSafe(Accessoire.class);
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.slot.getName());
        buf.writeRegistryId((IForgeRegistryEntry)this.accessoire);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                player.getCapability(CapabilityAccessoires.ACCESSOIRES).ifPresent(arg_0 -> this.lambda$null$0((PlayerEntity)player, arg_0));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private /* synthetic */ void lambda$null$0(PlayerEntity player, IAccessoireHolder accessoireHolder) {
        if (this.slot != null && this.accessoire != null) {
            Collection<Accessoire> accessoires = accessoireHolder.getSlots().get(this.slot);
            if (accessoires == null || !accessoires.contains((Object)this.accessoire)) {
                accessoireHolder.enable(this.slot, this.accessoire, player);
            } else {
                accessoireHolder.disable(this.slot, this.accessoire, player);
            }
        }
    }
}

