/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.threetag.threecore.capability.CapabilityThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class UpdateThreeDataMessage {
    public int entityId;
    public String dataKey;
    public CompoundNBT dataTag;

    public UpdateThreeDataMessage(int entityId, String dataKey, CompoundNBT dataTag) {
        this.entityId = entityId;
        this.dataKey = dataKey;
        this.dataTag = dataTag;
    }

    public UpdateThreeDataMessage(PacketBuffer buf) {
        this.entityId = buf.readInt();
        this.dataKey = buf.func_150789_c(32);
        this.dataTag = buf.func_150793_b();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.func_180714_a(this.dataKey);
        buf.func_150786_a(this.dataTag);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId);
            if (entity != null) {
                entity.getCapability(CapabilityThreeData.THREE_DATA).ifPresent(threeDataHolder -> {
                    ThreeData<?> data = threeDataHolder.getDataByName(this.dataKey);
                    threeDataHolder.readValue(data, this.dataTag);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

