/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.scripts;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.event.AbilityEnableChangeEvent;
import net.threetag.threecore.event.RegisterThreeDataEvent;
import net.threetag.threecore.event.SetRotationAnglesEvent;
import net.threetag.threecore.network.EmptyHandInteractMessage;
import net.threetag.threecore.scripts.ScriptParameterName;
import net.threetag.threecore.scripts.events.AbilityDataUpdatedScriptEvent;
import net.threetag.threecore.scripts.events.AbilityDisabledScriptEvent;
import net.threetag.threecore.scripts.events.AbilityEnabledScriptEvent;
import net.threetag.threecore.scripts.events.AbilityLockedScriptEvent;
import net.threetag.threecore.scripts.events.AbilityTickScriptEvent;
import net.threetag.threecore.scripts.events.AbilityUnlockedScriptEvent;
import net.threetag.threecore.scripts.events.ConditionDataUpdatedScriptEvent;
import net.threetag.threecore.scripts.events.EntityInteractSpecificScriptEvent;
import net.threetag.threecore.scripts.events.EntityJoinWorldScriptEvent;
import net.threetag.threecore.scripts.events.EntityStruckByLightningScriptEvent;
import net.threetag.threecore.scripts.events.LeftClickBlockScriptEvent;
import net.threetag.threecore.scripts.events.LeftClickEmptyScriptEvent;
import net.threetag.threecore.scripts.events.LivingAttackScriptEvent;
import net.threetag.threecore.scripts.events.LivingDeathScriptEvent;
import net.threetag.threecore.scripts.events.LivingFallScriptEvent;
import net.threetag.threecore.scripts.events.LivingHurtScriptEvent;
import net.threetag.threecore.scripts.events.LivingJumpScriptEvent;
import net.threetag.threecore.scripts.events.LivingUpdateScriptEvent;
import net.threetag.threecore.scripts.events.MultiJumpScriptEvent;
import net.threetag.threecore.scripts.events.ProjectileImpactScriptEvent;
import net.threetag.threecore.scripts.events.ProjectileTickScriptEvent;
import net.threetag.threecore.scripts.events.RegisterAbilityThreeDataScriptEvent;
import net.threetag.threecore.scripts.events.RegisterEntityThreeDataScriptEvent;
import net.threetag.threecore.scripts.events.RightClickBlockScriptEvent;
import net.threetag.threecore.scripts.events.RightClickEmptyScriptEvent;
import net.threetag.threecore.scripts.events.RightClickItemScriptEvent;
import net.threetag.threecore.scripts.events.ScriptEvent;
import net.threetag.threecore.scripts.events.SetRotationAnglesScriptEvent;
import net.threetag.threecore.scripts.events.SuperpowerSetScriptEvent;
import net.threetag.threecore.util.documentation.DocumentationBuilder;

public class ScriptEventManager {
    private static Map<Class<? extends ScriptEvent>, List<IEventHandler>> subscribed = Maps.newHashMap();
    private static Map<String, Class<? extends ScriptEvent>> events = Maps.newHashMap();

    public static void reset() {
        subscribed.clear();
    }

    public static void subscribe(Class<? extends ScriptEvent> eventClass, IEventHandler eventHandler) {
        if (!subscribed.containsKey(eventClass)) {
            subscribed.put(eventClass, Lists.newLinkedList());
        }
        subscribed.get(eventClass).add(eventHandler);
    }

    public static void subscribe(String eventName, IEventHandler eventHandler) {
        Class<? extends ScriptEvent> clazz = events.get(eventName);
        if (clazz != null) {
            ScriptEventManager.subscribe(clazz, eventHandler);
        }
    }

    public static void registerEvent(String name, Class<? extends ScriptEvent> eventClass) {
        events.put(name, eventClass);
    }

    public static void fireEvent(ScriptEvent event) {
        if (subscribed.containsKey(event.getClass())) {
            subscribed.get(event.getClass()).forEach(inv -> inv.onEvent(event));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void generateDocumentation() {
        List<String> ignoredMethods = Arrays.asList("fire", "wait", "equals", "toString", "hashCode", "getClass", "notify", "notifyAll");
        DocumentationBuilder builder = new DocumentationBuilder(new ResourceLocation("threecore", "scripts/events"), "Script Events").add(DocumentationBuilder.heading("Script Events")).add(DocumentationBuilder.hr()).add(DocumentationBuilder.paragraph(DocumentationBuilder.subHeading("Overview")).add(DocumentationBuilder.list(events.entrySet().stream().map(entry -> DocumentationBuilder.link(entry.getKey(), "#" + (String)entry.getKey())).collect(Collectors.toList()))));
        for (Map.Entry<String, Class<? extends ScriptEvent>> entry2 : events.entrySet()) {
            builder.add(DocumentationBuilder.hr()).add(DocumentationBuilder.div(new Object[0]).setId(entry2.getKey()).add(DocumentationBuilder.subHeading(entry2.getKey())).add(DocumentationBuilder.table(Arrays.asList("Function", "Return Type", "Parameters"), Arrays.stream(entry2.getValue().getMethods()).filter(method -> !ignoredMethods.contains(method.getName()) && !Modifier.isStatic(method.getModifiers())).map(method -> {
                LinkedList<String> columns = new LinkedList<String>();
                columns.add(method.getName());
                columns.add(method.getReturnType().getSimpleName());
                if (method.getParameterCount() <= 0) {
                    columns.add("/");
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < method.getParameterCount(); ++i) {
                        String parameterName = method.getParameters()[i].getName();
                        ScriptParameterName scriptParameterName = method.getParameters()[i].getAnnotation(ScriptParameterName.class);
                        if (scriptParameterName != null) {
                            parameterName = scriptParameterName.value();
                        }
                        stringBuilder.append("<strong>").append(parameterName).append("</strong> - ").append(method.getParameterTypes()[i].getSimpleName());
                        if (method.getParameterCount() <= 1) continue;
                        stringBuilder.append("<br>");
                    }
                    columns.add(stringBuilder.toString());
                }
                return columns;
            }).collect(Collectors.toList()))));
        }
        builder.save();
    }

    static {
        ScriptEventManager.registerEvent("entityJoinWorld", EntityJoinWorldScriptEvent.class);
        ScriptEventManager.registerEvent("entityStruckByLightning", EntityStruckByLightningScriptEvent.class);
        ScriptEventManager.registerEvent("livingUpdate", LivingUpdateScriptEvent.class);
        ScriptEventManager.registerEvent("livingJump", LivingJumpScriptEvent.class);
        ScriptEventManager.registerEvent("livingAttack", LivingAttackScriptEvent.class);
        ScriptEventManager.registerEvent("livingHurt", LivingHurtScriptEvent.class);
        ScriptEventManager.registerEvent("livingDeath", LivingDeathScriptEvent.class);
        ScriptEventManager.registerEvent("livingFall", LivingFallScriptEvent.class);
        ScriptEventManager.registerEvent("abilityTick", AbilityTickScriptEvent.class);
        ScriptEventManager.registerEvent("abilityLocked", AbilityLockedScriptEvent.class);
        ScriptEventManager.registerEvent("abilityUnlocked", AbilityUnlockedScriptEvent.class);
        ScriptEventManager.registerEvent("abilityEnabled", AbilityEnabledScriptEvent.class);
        ScriptEventManager.registerEvent("abilityDisabled", AbilityDisabledScriptEvent.class);
        ScriptEventManager.registerEvent("abilityDataUpdated", AbilityDataUpdatedScriptEvent.class);
        ScriptEventManager.registerEvent("conditionDataUpdated", ConditionDataUpdatedScriptEvent.class);
        ScriptEventManager.registerEvent("registerEntityThreeData", RegisterEntityThreeDataScriptEvent.class);
        ScriptEventManager.registerEvent("registerAbilityThreeData", RegisterAbilityThreeDataScriptEvent.class);
        ScriptEventManager.registerEvent("multiJump", MultiJumpScriptEvent.class);
        ScriptEventManager.registerEvent("projectileImpact", ProjectileImpactScriptEvent.class);
        ScriptEventManager.registerEvent("projectileTick", ProjectileTickScriptEvent.class);
        ScriptEventManager.registerEvent("superpowerSet", SuperpowerSetScriptEvent.class);
        ScriptEventManager.registerEvent("entityInteract", EntityInteractSpecificScriptEvent.class);
        ScriptEventManager.registerEvent("rightClickBlock", RightClickBlockScriptEvent.class);
        ScriptEventManager.registerEvent("rightClickItem", RightClickItemScriptEvent.class);
        ScriptEventManager.registerEvent("leftClickBlock", LeftClickBlockScriptEvent.class);
        ScriptEventManager.registerEvent("leftClickEmpty", LeftClickEmptyScriptEvent.class);
        ScriptEventManager.registerEvent("rightClickEmpty", RightClickEmptyScriptEvent.class);
        ScriptEventManager.registerEvent("setRotationAngles", SetRotationAnglesScriptEvent.class);
    }

    @Mod.EventBusSubscriber(modid="threecore")
    public static class EventHandler {
        @SubscribeEvent
        public static void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
            new LivingUpdateScriptEvent(e.getEntityLiving()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onLivingJump(LivingEvent.LivingJumpEvent e) {
            new LivingJumpScriptEvent(e.getEntityLiving()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onEntityJoinWorld(EntityJoinWorldEvent e) {
            new EntityJoinWorldScriptEvent(e.getEntity()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent e) {
            new LivingAttackScriptEvent(e.getEntityLiving(), e.getSource(), e.getAmount()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent e) {
            new LivingDeathScriptEvent(e.getEntityLiving(), e.getSource()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onLivingFall(LivingFallEvent e) {
            LivingFallScriptEvent scriptEvent = new LivingFallScriptEvent(e.getEntityLiving(), e.getDistance(), e.getDamageMultiplier());
            scriptEvent.fire((Event)e);
            e.setDistance(scriptEvent.getDistance());
            e.setDamageMultiplier(scriptEvent.getDamageMultiplier());
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent e) {
            LivingHurtScriptEvent scriptEvent = new LivingHurtScriptEvent(e.getEntityLiving(), e.getSource(), e.getAmount());
            scriptEvent.fire((Event)e);
            e.setAmount(scriptEvent.getAmount());
        }

        @SubscribeEvent
        public static void onEntityStruckByLightning(EntityStruckByLightningEvent e) {
            new EntityStruckByLightningScriptEvent(e.getEntity(), e.getLightning()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onRegisterThreeData(RegisterThreeDataEvent e) {
            new RegisterEntityThreeDataScriptEvent(e.getEntity(), e.getThreeData()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onProjectileImpactEvent(ProjectileImpactEvent e) {
            new ProjectileImpactScriptEvent(e.getEntity()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onEntityInteractSpecificEvent(PlayerInteractEvent.EntityInteractSpecific e) {
            new EntityInteractSpecificScriptEvent(e).fire((Event)e);
        }

        @SubscribeEvent
        public static void onRightClickBlockEvent(PlayerInteractEvent.RightClickBlock e) {
            new RightClickBlockScriptEvent((PlayerInteractEvent)e).fire((Event)e);
        }

        @SubscribeEvent
        public static void onRightClickItemEvent(PlayerInteractEvent.RightClickItem e) {
            new RightClickItemScriptEvent((PlayerInteractEvent)e).fire((Event)e);
        }

        @SubscribeEvent
        public static void onLeftClickBlockEvent(PlayerInteractEvent.LeftClickBlock e) {
            new LeftClickBlockScriptEvent((PlayerInteractEvent)e).fire((Event)e);
        }

        @SubscribeEvent
        public static void onLeftClickEmptyEvent(PlayerInteractEvent.LeftClickEmpty e) {
            new LeftClickEmptyScriptEvent(e).fire((Event)e);
            ThreeCore.NETWORK_CHANNEL.sendToServer((Object)new EmptyHandInteractMessage(true));
        }

        @SubscribeEvent
        public static void onRightClickEmptyEvent(PlayerInteractEvent.RightClickEmpty e) {
            new RightClickEmptyScriptEvent((PlayerInteractEvent)e).fire((Event)e);
            ThreeCore.NETWORK_CHANNEL.sendToServer((Object)new EmptyHandInteractMessage(false));
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onSetRotationAngles(SetRotationAnglesEvent e) {
            new SetRotationAnglesScriptEvent(e).fire((Event)e);
        }

        @SubscribeEvent
        public static void onAbilityEnableChange(AbilityEnableChangeEvent e) {
            switch (e.type) {
                case ENABLED: {
                    if (!new AbilityEnabledScriptEvent(e.getEntityLiving(), e.ability).fire()) break;
                    e.setCanceled(true);
                    break;
                }
                case DISABLED: {
                    if (!new AbilityDisabledScriptEvent(e.getEntityLiving(), e.ability).fire()) break;
                    e.setCanceled(true);
                }
            }
        }
    }

    public static interface IEventHandler {
        public void onEvent(ScriptEvent var1);
    }

    public static class EventManagerAccessor {
        public void on(String eventName, IEventHandler eventHandler) {
            if (eventHandler != null) {
                ScriptEventManager.subscribe(eventName, eventHandler);
            }
        }
    }
}

