/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.scripts.accessors;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.scripts.ScriptParameterName;
import net.threetag.threecore.scripts.accessors.AbilityAccessor;
import net.threetag.threecore.scripts.accessors.BlockRayTraceResultAccessor;
import net.threetag.threecore.scripts.accessors.BlockStateAccessor;
import net.threetag.threecore.scripts.accessors.CompoundNBTAccessor;
import net.threetag.threecore.scripts.accessors.ConditionAccessor;
import net.threetag.threecore.scripts.accessors.DamageSourceAccessor;
import net.threetag.threecore.scripts.accessors.EntityAccessor;
import net.threetag.threecore.scripts.accessors.EntityRayTraceResultAccessor;
import net.threetag.threecore.scripts.accessors.ItemStackAccessor;
import net.threetag.threecore.scripts.accessors.LivingEntityAccessor;
import net.threetag.threecore.scripts.accessors.MaterialAccessor;
import net.threetag.threecore.scripts.accessors.Vector3dAccessor;
import net.threetag.threecore.scripts.accessors.WorldAccessor;
import net.threetag.threecore.util.documentation.DocumentationBuilder;

public class ScriptAccessor<T> {
    public final T value;
    public static List<Class<? extends ScriptAccessor<?>>> accessorClasses = Arrays.asList(EntityAccessor.class, LivingEntityAccessor.class, WorldAccessor.class, BlockStateAccessor.class, DamageSourceAccessor.class, AbilityAccessor.class, ConditionAccessor.class, CompoundNBTAccessor.class, Vector3dAccessor.class, MaterialAccessor.class, ItemStackAccessor.class, BlockRayTraceResultAccessor.class, EntityRayTraceResultAccessor.class);

    protected ScriptAccessor(T value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        return this.value.equals(obj);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static <T> ScriptAccessor<T> makeAccessor(T object) {
        if (object instanceof LivingEntity) {
            return new LivingEntityAccessor((LivingEntity)object);
        }
        if (object instanceof Entity) {
            return new EntityAccessor((Entity)object);
        }
        if (object instanceof World) {
            return new WorldAccessor((World)object);
        }
        if (object instanceof BlockState) {
            return new BlockStateAccessor((BlockState)object);
        }
        if (object instanceof DamageSource) {
            return new DamageSourceAccessor((DamageSource)object);
        }
        if (object instanceof Ability) {
            return new AbilityAccessor((Ability)object);
        }
        if (object instanceof Condition) {
            return new ConditionAccessor((Condition)object);
        }
        if (object instanceof Vector3d) {
            return new Vector3dAccessor((Vector3d)object);
        }
        if (object instanceof Material) {
            return new MaterialAccessor((Material)object);
        }
        if (object instanceof EntityRayTraceResult) {
            return new EntityRayTraceResultAccessor((EntityRayTraceResult)object);
        }
        if (object instanceof BlockRayTraceResult) {
            return new BlockRayTraceResultAccessor((BlockRayTraceResult)object);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void generateDocumentation() {
        List<String> ignoredMethods = Arrays.asList("fire", "wait", "equals", "toString", "hashCode", "getClass", "notify", "notifyAll");
        DocumentationBuilder builder = new DocumentationBuilder(new ResourceLocation("threecore", "scripts/accessors"), "Script Accessors").add(DocumentationBuilder.heading("Script Accessors")).add(DocumentationBuilder.hr()).add(DocumentationBuilder.paragraph(DocumentationBuilder.subHeading("Overview")).add(DocumentationBuilder.list(accessorClasses.stream().map(clazz -> DocumentationBuilder.link(clazz.getSimpleName(), "#" + clazz.getSimpleName())).collect(Collectors.toList()))));
        for (Class<ScriptAccessor<?>> clazz2 : accessorClasses) {
            builder.add(DocumentationBuilder.hr()).add(DocumentationBuilder.div(new Object[0]).setId(clazz2.getSimpleName()).add(DocumentationBuilder.subHeading(clazz2.getSimpleName() + (clazz2.getSuperclass() != ScriptAccessor.class ? " <code>extends " + clazz2.getSuperclass().getSimpleName() + "</code>" : ""))).add(DocumentationBuilder.table(Arrays.asList("Function", "Return Type", "Parameters"), Arrays.stream(clazz2.getMethods()).filter(method -> !ignoredMethods.contains(method.getName()) && !Modifier.isStatic(method.getModifiers())).map(method -> {
                LinkedList<String> columns = new LinkedList<String>();
                columns.add(method.getName());
                columns.add(method.getReturnType().getSimpleName());
                if (method.getParameterCount() <= 0) {
                    columns.add("/");
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < method.getParameterCount(); ++i) {
                        String parameterName = method.getParameters()[i].getName();
                        ScriptParameterName scriptParameterName = method.getParameters()[i].getAnnotation(ScriptParameterName.class);
                        if (scriptParameterName != null) {
                            parameterName = scriptParameterName.value();
                        }
                        stringBuilder.append("<strong>").append(parameterName).append("</strong> - ").append(method.getParameterTypes()[i].getSimpleName());
                        if (method.getParameterCount() <= 1) continue;
                        stringBuilder.append("<br>");
                    }
                    columns.add(stringBuilder.toString());
                }
                return columns;
            }).collect(Collectors.toList()))));
        }
        builder.save();
    }
}

