/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.scripts.accessors;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.scripts.ScriptCommandSource;
import net.threetag.threecore.scripts.ScriptParameterName;
import net.threetag.threecore.scripts.accessors.BlockStateAccessor;
import net.threetag.threecore.scripts.accessors.EntityAccessor;
import net.threetag.threecore.scripts.accessors.LivingEntityAccessor;
import net.threetag.threecore.scripts.accessors.ScriptAccessor;
import net.threetag.threecore.util.PlayerUtil;

public class WorldAccessor
extends ScriptAccessor<World> {
    public WorldAccessor(World value) {
        super(value);
    }

    public long getTime() {
        return ((World)this.value).func_72820_D();
    }

    public void setTime(@ScriptParameterName(value="time") long time) {
        if (this.value instanceof ServerWorld) {
            ((ServerWorld)this.value).func_241114_a_(time);
        }
    }

    public boolean isRaining() {
        return ((World)this.value).func_72896_J();
    }

    public boolean isThundering() {
        return ((World)this.value).func_72911_I();
    }

    public boolean isRemote() {
        return ((World)this.value).field_72995_K;
    }

    public void setRainStrength(@ScriptParameterName(value="strength") float strength) {
        ((World)this.value).func_72894_k(strength);
    }

    public void playSound(@ScriptParameterName(value="id") String id, @ScriptParameterName(value="id") String soundCategory, @ScriptParameterName(value="posX") double posX, @ScriptParameterName(value="posY") double posY, @ScriptParameterName(value="posZ") double posZ, @ScriptParameterName(value="volume") float volume, @ScriptParameterName(value="pitch") float pitch) {
        SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(id));
        SoundCategory category = null;
        for (SoundCategory category1 : SoundCategory.values()) {
            if (!category1.func_187948_a().equalsIgnoreCase(soundCategory)) continue;
            category = category1;
            break;
        }
        if (soundEvent != null && category != null) {
            PlayerUtil.playSoundToAll((World)this.value, posX, posY, posZ, 50.0, soundEvent, category, volume, pitch);
        }
    }

    public void summonLightning(@ScriptParameterName(value="x") double x, @ScriptParameterName(value="y") double y, @ScriptParameterName(value="z") double z, @ScriptParameterName(value="effectOnly") boolean effectOnly) {
        if (this.value instanceof ServerWorld) {
            LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((World)this.value);
            lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)new BlockPos(x, y, z)));
            lightningboltentity.func_233623_a_(effectOnly);
            ((World)this.value).func_217376_c((Entity)lightningboltentity);
        }
    }

    public void setBlockState(@ScriptParameterName(value="block") Object block, @ScriptParameterName(value="x") int x, @ScriptParameterName(value="y") int y, @ScriptParameterName(value="z") int z) {
        BlockState b;
        Object object = block instanceof BlockStateAccessor ? (BlockState)((BlockStateAccessor)block).value : (b = block instanceof String && ForgeRegistries.BLOCKS.containsKey(new ResourceLocation((String)block)) ? ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)block))).func_176223_P() : null);
        if (block != null) {
            ((World)this.value).func_175656_a(new BlockPos(x, y, z), b);
        }
    }

    public BlockStateAccessor getBlockState(@ScriptParameterName(value="x") int x, @ScriptParameterName(value="y") int y, @ScriptParameterName(value="z") int z) {
        return (BlockStateAccessor)ScriptAccessor.makeAccessor(((World)this.value).func_180495_p(new BlockPos(x, y, z)));
    }

    public void executeCommand(@ScriptParameterName(value="command") String command) {
        if (this.value instanceof ServerWorld) {
            CommandSource commandSource = new CommandSource((ICommandSource)new ScriptCommandSource(), Vector3d.func_237491_b_((Vector3i)((ServerWorld)this.value).func_241135_u_()), Vector2f.field_189974_a, (ServerWorld)this.value, 4, "Script", (ITextComponent)new StringTextComponent("Script"), ((World)this.value).func_73046_m(), (Entity)null);
            ((World)this.value).func_73046_m().func_195571_aL().func_197059_a(commandSource, command);
        }
    }

    public EntityAccessor[] getEntitiesInBox(@ScriptParameterName(value="x1") double x1, @ScriptParameterName(value="y1") double y1, @ScriptParameterName(value="z1") double z1, @ScriptParameterName(value="x2") double x2, @ScriptParameterName(value="y2") double y2, @ScriptParameterName(value="z2") double z2) {
        List list = ((World)this.value).func_175647_a(Entity.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2), t -> true);
        EntityAccessor[] array = new EntityAccessor[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = new EntityAccessor((Entity)list.get(i));
        }
        return array;
    }

    public LivingEntityAccessor[] getLivingEntitiesInBox(@ScriptParameterName(value="x1") double x1, @ScriptParameterName(value="y1") double y1, @ScriptParameterName(value="z1") double z1, @ScriptParameterName(value="x2") double x2, @ScriptParameterName(value="y2") double y2, @ScriptParameterName(value="z2") double z2) {
        List list = ((World)this.value).func_175647_a(LivingEntity.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2), t -> true);
        LivingEntityAccessor[] array = new LivingEntityAccessor[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = new LivingEntityAccessor((LivingEntity)list.get(i));
        }
        return array;
    }
}

