/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.threetag.threecore.block.MachineBlock;
import net.threetag.threecore.item.recipe.IEnergyRecipe;
import net.threetag.threecore.tileentity.MachineTileEntity;
import net.threetag.threecore.util.EntityUtil;

public abstract class ProgressableMachineTileEntity<T extends IEnergyRecipe<IInventory>>
extends MachineTileEntity {
    public T recipe;
    public int progress;
    public int maxProgress;
    private final Map<ResourceLocation, Integer> xpMap = Maps.newHashMap();

    public ProgressableMachineTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        boolean working = this.isWorking();
        boolean dirty = false;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.recipe != null && this.energyStorage.extractEnergy(1, true) == 1 && this.canWork(this.recipe)) {
                this.maxProgress = this.recipe.getRequiredEnergy();
                if (this.progress >= this.maxProgress) {
                    this.addXP();
                    this.produceOutput(this.recipe);
                    this.progress = 0;
                    dirty = true;
                } else {
                    ++this.progress;
                    this.energyStorage.extractEnergy(1, false);
                }
            } else {
                this.progress = 0;
            }
        }
        if (working != this.isWorking()) {
            dirty = true;
            if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)MachineBlock.LIT)).booleanValue()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)MachineBlock.LIT, (Comparable)Boolean.valueOf(this.isWorking())), 3);
            }
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    public abstract IRecipeType<T> getRecipeType();

    public float getXpFromRecipe(T recipe) {
        return 0.0f;
    }

    public boolean isWorking() {
        return this.progress > 0;
    }

    public abstract boolean canWork(T var1);

    public abstract void produceOutput(T var1);

    public void addXP() {
        if (this.xpMap != null) {
            this.xpMap.compute(this.recipe.func_199560_c(), (resourceLocation, integer) -> 1 + (integer == null ? 0 : integer));
        }
    }

    public void updateRecipe(T recipe) {
        this.recipe = recipe;
    }

    public void updateRecipe(IInventory inventory) {
        if (this.func_145831_w() != null) {
            this.recipe = this.func_145831_w().func_199532_z().func_215366_a(this.getRecipeType()).values().stream().flatMap(recipe -> Util.func_215081_a((Optional)this.getRecipeType().func_222148_a(recipe, this.func_145831_w(), inventory))).findFirst().orElse(null);
        }
    }

    public void unlockRecipes(PlayerEntity player) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, Integer> entry : this.xpMap.entrySet()) {
            player.field_70170_p.func_199532_z().func_215367_a(entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                EntityUtil.spawnXP(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, (Integer)entry.getValue(), this.getXpFromRecipe((IEnergyRecipe)recipe));
            });
        }
        player.func_195065_a((Collection)list);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.recipe = this.getRecipe(new ResourceLocation(nbt.func_74779_i("Recipe")));
        this.progress = nbt.func_74762_e("Progress");
        this.maxProgress = nbt.func_74762_e("MaxProgress");
        int i = nbt.func_74765_d("RecipesUsedSize");
        for (int j = 0; j < i; ++j) {
            ResourceLocation resourcelocation = new ResourceLocation(nbt.func_74779_i("RecipeLocation" + j));
            int k = nbt.func_74762_e("RecipeAmount" + j);
            this.xpMap.put(resourcelocation, k);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        if (this.recipe != null) {
            nbt.func_74778_a("Recipe", this.recipe.func_199560_c().toString());
        }
        nbt.func_74768_a("Progress", this.progress);
        nbt.func_74768_a("MaxProgress", this.maxProgress);
        nbt.func_74777_a("RecipesUsedSize", (short)this.xpMap.size());
        int i = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.xpMap.entrySet()) {
            nbt.func_74778_a("RecipeLocation" + i, entry.getKey().toString());
            nbt.func_74768_a("RecipeAmount" + i, entry.getValue().intValue());
            ++i;
        }
        return super.func_189515_b(nbt);
    }

    private T getRecipe(ResourceLocation id) {
        if (this.func_145831_w() == null) {
            return null;
        }
        for (IRecipe recipe : this.func_145831_w().func_199532_z().func_199510_b()) {
            if (recipe.func_222127_g() != this.getRecipeType() || !recipe.func_199560_c().equals((Object)id)) continue;
            return (T)((IEnergyRecipe)recipe);
        }
        return null;
    }
}

