/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeUtil {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static <T extends IRecipe<?>> IRecipeType<T> register(String id) {
        return RecipeUtil.register(new ResourceLocation("threecore", id));
    }

    public static <T extends IRecipe<?>> IRecipeType<T> register(final ResourceLocation name) {
        return (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)name, (Object)new IRecipeType<T>(){

            public String toString() {
                return name.toString();
            }
        });
    }

    public static ItemStack parseItemStackExt(JsonObject json, boolean readNBT) {
        if (json.has("tag")) {
            ITag tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag")));
            if (tag == null || tag.func_230236_b_().size() <= 0) {
                throw new JsonSyntaxException("Unknown tag '" + JSONUtils.func_151200_h((JsonObject)json, (String)"tag") + "'");
            }
            Item item = (Item)Lists.newArrayList((Iterable)tag.func_230236_b_()).get(0);
            if (readNBT && json.has("nbt")) {
                try {
                    JsonElement element = json.get("nbt");
                    CompoundNBT nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(element)) : JsonToNBT.func_180713_a((String)element.getAsString());
                    CompoundNBT tmp = new CompoundNBT();
                    if (nbt.func_74764_b("ForgeCaps")) {
                        tmp.func_218657_a("ForgeCaps", nbt.func_74781_a("ForgeCaps"));
                        nbt.func_82580_o("ForgeCaps");
                    }
                    tmp.func_218657_a("tag", (INBT)nbt);
                    tmp.func_74778_a("id", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).toString());
                    tmp.func_74768_a("Count", JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
                    return ItemStack.func_199557_a((CompoundNBT)tmp);
                }
                catch (CommandSyntaxException e) {
                    throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
                }
            }
            return new ItemStack((IItemProvider)item, JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
        }
        return CraftingHelper.getItemStack((JsonObject)json, (boolean)readNBT);
    }
}

