/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.threetag.threecore.ability.Ability;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtil {
    public static float renderTickTime;
    private static LivingEntity currentEntityInItemRendering;
    private static Ability currentAbilityInIconRendering;

    public static void onRenderGlobal(TickEvent.RenderTickEvent e) {
        renderTickTime = e.renderTickTime;
    }

    public static void setCurrentEntityInItemRendering(LivingEntity entity) {
        currentEntityInItemRendering = entity;
    }

    @Nullable
    public static LivingEntity getCurrentEntityInItemRendering() {
        return currentEntityInItemRendering;
    }

    public static void setCurrentAbilityInIconRendering(Ability ability) {
        currentAbilityInIconRendering = ability;
    }

    public static Ability getCurrentAbilityInIconRendering() {
        return currentAbilityInIconRendering;
    }

    public static void renderFilledBox(Matrix4f matrix, IVertexBuilder builder, AxisAlignedBB boundingBox, float red, float green, float blue, float alpha, int combinedLightIn) {
        RenderUtil.renderFilledBox(matrix, builder, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f, red, green, blue, alpha, combinedLightIn);
    }

    public static void renderFilledBox(Matrix4f matrix, IVertexBuilder builder, float startX, float startY, float startZ, float endX, float endY, float endZ, float red, float green, float blue, float alpha, int combinedLightIn) {
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
    }

    public static void drawGlowingLine(Matrix4f matrix, IVertexBuilder builder, float length, float width, float red, float green, float blue, float alpha, int combinedLightIn) {
        AxisAlignedBB box = new AxisAlignedBB((double)(-width / 2.0f), 0.0, (double)(-width / 2.0f), (double)(width / 2.0f), (double)length, (double)(width / 2.0f));
        RenderUtil.renderFilledBox(matrix, builder, box, 1.0f, 1.0f, 1.0f, alpha, combinedLightIn);
        for (int i = 0; i < 3; ++i) {
            RenderUtil.renderFilledBox(matrix, builder, box.func_186662_g((double)((float)i * 0.5f * 0.0625f)), red, green, blue, 1.0f / (float)i / 2.0f * alpha, combinedLightIn);
        }
    }

    public static void renderGuiTank(IFluidHandler fluidHandler, int tank, double x, double y, double zLevel, double width, double height) {
        FluidStack stack = fluidHandler.getFluidInTank(tank);
        int tankCapacity = fluidHandler.getTankCapacity(tank);
        RenderUtil.renderGuiTank(stack, tankCapacity, x, y, zLevel, width, height);
    }

    public static void renderGuiTank(FluidStack stack, int tankCapacity, double x, double y, double zLevel, double width, double height) {
        int amount = stack.getAmount();
        if (stack.getFluid() == null || amount <= 0) {
            return;
        }
        ResourceLocation stillTexture = stack.getFluid().getAttributes().getStillTexture();
        TextureAtlasSprite icon = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(stillTexture);
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)tankCapacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        RenderUtil.setColorRGBA(stack.getFluid().getAttributes().getColor(stack));
        RenderSystem.enableBlend();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                float minU = icon.func_94209_e();
                float maxU = icon.func_94212_f();
                float minV = icon.func_94206_g();
                float maxV = icon.func_94210_h();
                float u = minU + (maxU - minU) * (float)drawWidth / 16.0f;
                float v = minV + (maxV - minV) * (float)drawHeight / 16.0f;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                tes.func_225582_a_((double)drawX, (double)(drawY + drawHeight), zLevel).func_225583_a_(minU, v).func_181675_d();
                tes.func_225582_a_((double)(drawX + drawWidth), (double)(drawY + drawHeight), zLevel).func_225583_a_(u, v).func_181675_d();
                tes.func_225582_a_((double)(drawX + drawWidth), (double)drawY, zLevel).func_225583_a_(u, minV).func_181675_d();
                tes.func_225582_a_((double)drawX, (double)drawY, zLevel).func_225583_a_(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLine(Matrix4f matrix, IVertexBuilder builder, float width, float length, float red, float green, float blue, float alpha, int combinedLightIn) {
        RenderUtil.drawLine(matrix, builder, width, length, true, true, red, green, blue, alpha, combinedLightIn);
    }

    public static void drawLine(Matrix4f matrix, IVertexBuilder builder, float width, float length, boolean drawTop, boolean drawBottom, float red, float green, float blue, float alpha, int combinedLightIn) {
        RenderUtil.renderFilledBox(matrix, builder, -width / 2.0f, 0.0f, -width / 2.0f, width / 2.0f, length, width / 2.0f, red, green, blue, alpha, combinedLightIn);
    }

    public static void setColorRGBA(int color) {
        float a = (float)RenderUtil.alpha(color) / 255.0f;
        float r = (float)RenderUtil.red(color) / 255.0f;
        float g = (float)RenderUtil.green(color) / 255.0f;
        float b = (float)RenderUtil.blue(color) / 255.0f;
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    static {
        currentEntityInItemRendering = null;
        currentAbilityInIconRendering = null;
    }

    public static class RenderTypes
    extends RenderType {
        public static final RenderType HYDRAULIC_PRESS_PISTONS = RenderTypes.func_228632_a_((String)"threecore:hydraulic_press_pistons", (VertexFormat)DefaultVertexFormats.field_227850_m_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228718_a_(field_239235_M_).func_228726_a_(field_228515_g_).func_228724_a_(field_228523_o_).func_228715_a_(field_228494_D_).func_228723_a_(RenderState.field_228520_l_).func_228714_a_(field_228534_z_).func_228719_a_(RenderState.field_228528_t_).func_228727_a_(field_228495_E_).func_228728_a_(false));
        public static final RenderType LASER = RenderTypes.func_228633_a_((String)"threecore:laser", (VertexFormat)DefaultVertexFormats.field_227850_m_, (int)7, (int)256, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(RenderState.field_228523_o_).func_228714_a_(RenderState.field_228534_z_).func_228713_a_(field_228517_i_).func_228726_a_(RenderState.field_228512_d_).func_228728_a_(true));

        public RenderTypes(String name, VertexFormat vertexFormat, int drawMode, int bufferSize, boolean useDelegate, boolean needsSorting, Runnable setupTask, Runnable clearTask) {
            super(name, vertexFormat, drawMode, bufferSize, useDelegate, needsSorting, setupTask, clearTask);
        }

        public static RenderType getGlowing(ResourceLocation locationIn) {
            RenderState.TextureState textureState = new RenderState.TextureState(locationIn, false, false);
            return RenderTypes.func_228633_a_((String)"threecore:glowing", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(field_228515_g_).func_228713_a_(field_228517_i_).func_228714_a_(field_228491_A_).func_228722_a_(field_228530_v_).func_228724_a_(textureState).func_228717_a_(field_228503_M_).func_228728_a_(false));
        }
    }
}

