/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.accessoires.Accessoire;
import net.threetag.threecore.capability.CapabilityAccessoires;
import net.threetag.threecore.capability.IAccessoireHolder;

@Mod.EventBusSubscriber(modid="threecore")
public class SupporterHandler {
    private static final String BASE_URL = "https://squirrelcontrol.threetag.net/api/";
    private static Map<UUID, PlayerData> DATA = Maps.newHashMap();
    private static boolean CHECK = false;

    public static PlayerData loadPlayerData(UUID uuid) {
        try {
            ServerPlayerEntity player;
            JsonObject json = SupporterHandler.readJsonFromUrl("https://squirrelcontrol.threetag.net/api/player/" + uuid.toString());
            PlayerData data = new PlayerData(uuid, JSONUtils.func_152754_s((JsonObject)json, (String)"data"));
            DATA.put(uuid, data);
            ThreeCore.LOGGER.info("Successfully read user's supporter data! (" + uuid.toString() + ")");
            if (ServerLifecycleHooks.getCurrentServer() != null && (player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid)) != null) {
                player.getCapability(CapabilityAccessoires.ACCESSOIRES).ifPresent(arg_0 -> SupporterHandler.lambda$loadPlayerData$0((PlayerEntity)player, arg_0));
            }
            return data;
        }
        catch (Exception e) {
            ThreeCore.LOGGER.error("Was not able to read user's supporter data! (" + uuid.toString() + ")");
            e.printStackTrace();
            PlayerData data = new PlayerData(uuid, new JsonObject());
            DATA.put(uuid, data);
            return data;
        }
    }

    public static void enableSupporterCheck() {
        if (!CHECK) {
            CHECK = true;
            ThreeCore.LOGGER.info("The supporter check has been enabled!");
        }
    }

    public static boolean isSupporterCheckEnabled() {
        return CHECK;
    }

    public static PlayerData getPlayerData(UUID uuid) {
        if (DATA.containsKey(uuid)) {
            return DATA.get(uuid);
        }
        PlayerData data = new PlayerData(uuid, new JsonObject());
        DATA.put(uuid, data);
        return data;
    }

    public static PlayerData getPlayerDataUnsafe(UUID uuid) {
        return DATA.get(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject readJsonFromUrl(String url) throws Exception {
        try (InputStream is = new URL(url).openStream();){
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            JsonObject json = new JsonParser().parse((Reader)rd).getAsJsonObject();
            if (JSONUtils.func_151203_m((JsonObject)json, (String)"error") != 200) {
                throw new Exception("Error while reading json: " + JSONUtils.func_151200_h((JsonObject)json, (String)"message"));
            }
            JsonObject jsonObject = json;
            return jsonObject;
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof PlayerEntity && !e.getEntity().field_70170_p.field_72995_K) {
            SupporterHandler.loadPlayerData(((PlayerEntity)e.getEntity()).func_146103_bH().getId());
            if (CHECK && !SupporterHandler.getPlayerData(((PlayerEntity)e.getEntity()).func_146103_bH().getId()).hasModAccess() && e.getEntity() instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)e.getEntity()).field_71135_a.func_194028_b((ITextComponent)new StringTextComponent("You are not allowed to use this mod! " + ((PlayerEntity)e.getEntity()).func_146103_bH().getId().toString()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onLogout(ClientPlayerNetworkEvent.LoggedOutEvent e) {
        if (e.getPlayer() != null) {
            DATA.remove(e.getPlayer().func_110124_au());
        }
    }

    private static /* synthetic */ void lambda$loadPlayerData$0(PlayerEntity player, IAccessoireHolder accessoires) {
        accessoires.validate(player);
    }

    public static class PlayerData {
        private final UUID uuid;
        private final List<Accessoire> accessoires;
        private final boolean modAccess;
        private final boolean hasCloak;
        private ResourceLocation cloakTexture;

        public PlayerData(UUID uuid, JsonObject json) {
            this.uuid = uuid;
            this.accessoires = Lists.newArrayList();
            JsonArray data = JSONUtils.func_151213_a((JsonObject)json, (String)"accessoires", (JsonArray)new JsonArray());
            for (int i = 0; i < data.size(); ++i) {
                ResourceLocation id = new ResourceLocation(data.get(i).getAsString());
                if (!Accessoire.REGISTRY.containsKey(id)) continue;
                this.accessoires.add((Accessoire)Accessoire.REGISTRY.getValue(id));
            }
            this.modAccess = JSONUtils.func_151209_a((JsonObject)json, (String)"mod_access", (boolean)false);
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"cloak")) {
                this.hasCloak = true;
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.loadCloakTexture(JSONUtils.func_151200_h((JsonObject)json, (String)"cloak")));
            } else {
                this.hasCloak = false;
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void loadCloakTexture(String url) {
            new Thread(() -> {
                try {
                    ResourceLocation resourceLocation = new ResourceLocation("threecore", "cloaks/" + this.uuid.toString());
                    Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourceLocation, (Texture)new DynamicTexture(NativeImage.func_195713_a((InputStream)new URL(url).openStream())));
                    this.cloakTexture = resourceLocation;
                }
                catch (IOException e) {
                    ThreeCore.LOGGER.error("Error loading supporter cloak texture: " + e.getMessage());
                }
            }).start();
        }

        public boolean hasModAccess() {
            return this.modAccess;
        }

        public boolean hasAccessoire(Accessoire accessoire) {
            return this.accessoires.contains((Object)accessoire);
        }

        public boolean hasCloak() {
            return this.hasCloak;
        }

        @Nullable
        public ResourceLocation getCloakTexture() {
            return this.cloakTexture;
        }
    }
}

