/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.documentation;

import com.mojang.datafixers.util.Pair;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.util.documentation.IDocumentationSettings;

public class DocumentationBuilder {
    public static final File SUBFOLDER = new File("mods/documentation/");
    public final ResourceLocation id;
    public final String title;
    private HTMLObject html;
    private HTMLObject head;
    private HTMLObject body;

    public DocumentationBuilder(ResourceLocation id, String title) {
        this(id, title, "https://i.imgur.com/am80ox1.png");
    }

    public DocumentationBuilder(ResourceLocation id, String title, String favicon) {
        this.id = id;
        this.title = title;
        this.init(favicon);
    }

    private void init(String favicon) {
        this.head = new HTMLObject("head").add(new HTMLObject("title", this.title)).add(new HTMLObject("style", "table{font-family:arial, sans-serif;border-collapse:collapse;}\ntd,th{border:1px solid #666666;text-align:left;padding:8px;min-width:45px;}\nth{background-color:#CCCCCC;}\np{margin:0;}\ntr:nth-child(even){background-color:#D8D8D8;}\ntr:nth-child(odd){background-color:#EEEEEE;}\ntd.true{background-color:#72FF85AA;}\ntd.false{background-color:#FF6666AA;}\ntd.other{background-color:#42A3FFAA;}\ntd.error{color:#FF0000;}\nth,td.true,td.false,td.other{text-align:center;}")).add(new HTMLObject("link").addAttribute("rel", "shortcut icon").addAttribute("type", "image/x-icon").addAttribute("href", favicon));
        this.body = new HTMLObject("body");
        this.html = new HTMLObject("html").add(this.head).add(this.body);
    }

    public DocumentationBuilder addStyle(String style) {
        this.head.add(new HTMLObject("style", style));
        return this;
    }

    public DocumentationBuilder addDocumentationSettings(List<IDocumentationSettings> settings) {
        HashMap<String, List> sorted = new HashMap<String, List>();
        for (IDocumentationSettings setting : settings) {
            String modName = AbilityType.getModContainerFromId(setting.getId().func_110624_b()) != null ? AbilityType.getModContainerFromId(setting.getId().func_110624_b()).getDisplayName() : setting.getId().func_110624_b();
            List<IDocumentationSettings> modsList = sorted.containsKey(modName) ? (List)sorted.get(modName) : new ArrayList();
            modsList.add(setting);
            sorted.put(modName, modsList);
        }
        HTMLObject overview = DocumentationBuilder.paragraph(DocumentationBuilder.subHeading("Overview"));
        this.addStyle(".json-block { background-color: lightgray; display: inline-block; border: 5px solid darkgray; padding: 10px }").add(DocumentationBuilder.hr()).add(overview);
        sorted.forEach((mod, settingsList) -> {
            overview.add(DocumentationBuilder.subSubHeading(mod));
            overview.add(DocumentationBuilder.list(settingsList.stream().map(setting -> DocumentationBuilder.link(setting.getId(), "#" + setting.getId().toString())).collect(Collectors.toList())));
        });
        sorted.values().forEach(modSettings -> modSettings.forEach(setting -> {
            HTMLObject div = DocumentationBuilder.div(new Object[0]).setId(setting.getId().toString()).add(DocumentationBuilder.subHeading(setting.getId().toString())).add(DocumentationBuilder.subSubHeading("Data Settings:")).add(DocumentationBuilder.table(setting.getColumns(), setting.getRows().stream().map(rows -> {
                ArrayList<String> list = new ArrayList<String>();
                for (Object object : rows) {
                    if (object == null) {
                        list.add("/");
                        continue;
                    }
                    if (object instanceof Boolean) {
                        list.add((Boolean)object != false ? "True" : "False");
                        continue;
                    }
                    if (object instanceof Class) {
                        list.add(((Class)object).getSimpleName());
                        continue;
                    }
                    list.add((String)object);
                }
                return list;
            }).collect(Collectors.toList())));
            this.add(DocumentationBuilder.hr()).add(div);
            if (setting.getExampleJson() != null) {
                div.add(DocumentationBuilder.subSubHeading("Example:")).add(new HTMLObject("pre").addAttribute("class", "json-block").setId(setting.getId().toString() + "_example")).add(DocumentationBuilder.js("var json = JSON.parse('" + setting.getExampleJson().toString() + "'); document.getElementById('" + setting.getId().toString() + "_example').innerHTML = JSON.stringify(json, undefined, 2);"));
            }
        }));
        return this;
    }

    public DocumentationBuilder add(HTMLObject html) {
        this.body.add(html);
        return this;
    }

    public static HTMLObject heading(String heading) {
        return new HTMLObject("h1", heading);
    }

    public static HTMLObject subHeading(String heading) {
        return new HTMLObject("h2", heading);
    }

    public static HTMLObject subSubHeading(String heading) {
        return new HTMLObject("h3", heading);
    }

    public static HTMLObject paragraph(Object ... objects) {
        return new HTMLObject("p", objects);
    }

    public static HTMLObject div(Object ... contents) {
        return new HTMLObject("div", contents);
    }

    public static HTMLObject js(String javascript) {
        return new HTMLObject("script", javascript);
    }

    public static HTMLObject link(Object text, String href) {
        return new HTMLObject("a", text).addAttribute("href", href);
    }

    public static HTMLObject list(Iterable<Object> objects) {
        HTMLObject list = new HTMLObject("ul");
        for (Object object : objects) {
            list.add(new HTMLObject("li", object));
        }
        return list;
    }

    public static HTMLObject numberedList(Iterable<Object> objects) {
        HTMLObject list = new HTMLObject("ol");
        for (Object object : objects) {
            list.add(new HTMLObject("li", object));
        }
        return list;
    }

    public static HTMLObject table(Iterable<?> head, Iterable<Iterable<?>> rows) {
        HTMLObject list = new HTMLObject("table");
        HTMLObject headRow = new HTMLObject("tr");
        list.add(new HTMLObject("thead").add(headRow));
        for (Object obj : head) {
            headRow.add(new HTMLObject("th", obj));
        }
        HTMLObject body = new HTMLObject("tbody");
        list.add(body);
        for (Iterable<?> rowObjects : rows) {
            HTMLObject row = new HTMLObject("tr");
            for (Object obj : rowObjects) {
                row.add(new HTMLObject("td", obj));
            }
            body.add(row);
        }
        return list;
    }

    public static HTMLObject br() {
        return new HTMLObject("br");
    }

    public static HTMLObject hr() {
        return new HTMLObject("hr");
    }

    public void save() {
        try {
            File file = new File(SUBFOLDER, this.id.func_110624_b() + "/" + this.id.func_110623_a() + ".html");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(this.html.toString());
            bw.close();
            ThreeCore.LOGGER.info("Successfully generated documentation file: " + file.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class HTMLObject {
        private final String tag;
        private final List<Object> content = new LinkedList<Object>();
        private final List<Pair<String, String>> attributes = new ArrayList<Pair<String, String>>();

        public HTMLObject(String tag) {
            this(tag, null);
        }

        public HTMLObject(String tag, Object ... content) {
            this.tag = tag;
            if (content != null) {
                this.content.addAll(Arrays.asList(content));
            }
        }

        public HTMLObject addAttribute(String key, String value) {
            this.attributes.add((Pair<String, String>)Pair.of((Object)key, (Object)value));
            return this;
        }

        public HTMLObject setId(String id) {
            this.attributes.add((Pair<String, String>)Pair.of((Object)"id", (Object)id));
            return this;
        }

        public HTMLObject add(Object content) {
            this.content.add(content);
            return this;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("<" + this.tag);
            this.attributes.forEach(pair -> result.append(" ").append((String)pair.getFirst()).append("=\"").append((String)pair.getSecond()).append("\""));
            result.append(">").append("\n");
            this.content.forEach(content -> {
                if (content instanceof Supplier) {
                    result.append(((Supplier)content).get().toString());
                } else {
                    result.append(content.toString());
                }
            });
            if (!(this.tag.equals("br") || this.tag.equals("hr") || this.tag.equals("link"))) {
                result.append("</").append(this.tag).append(">");
            }
            return result.append("\n").toString();
        }
    }
}

