/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.util.documentation.IDocumentationSettings;
import net.threetag.threecore.util.icon.IIcon;
import net.threetag.threecore.util.icon.IIconSerializer;
import net.threetag.threecore.util.icon.IconSerializer;
import net.threetag.threecore.util.icon.ItemIcon;
import net.threetag.threecore.util.icon.TexturedIcon;

public class CompoundIcon
implements IIcon {
    private IIcon[] icons;
    private int width;
    private int height;

    public CompoundIcon(IIcon ... icons) {
        for (IIcon icon : this.icons = icons) {
            if (icon.getWidth() > this.width) {
                this.width = icon.getWidth();
            }
            if (icon.getHeight() <= this.height) continue;
            this.height = icon.getHeight();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(Minecraft mc, MatrixStack stack, int x, int y) {
        for (IIcon icon : this.icons) {
            icon.draw(mc, stack, x, y);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public IIconSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIconSerializer<CompoundIcon>,
    IDocumentationSettings {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("threecore", "compound");

        @Override
        public CompoundIcon read(JsonObject json) {
            JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)json, (String)"icons");
            IIcon[] icons = new IIcon[jsonArray.size()];
            for (int i = 0; i < jsonArray.size(); ++i) {
                icons[i] = IconSerializer.deserialize(jsonArray.get(i).getAsJsonObject());
            }
            return new CompoundIcon(icons);
        }

        @Override
        public CompoundIcon read(CompoundNBT nbt) {
            ListNBT list = nbt.func_150295_c("Icons", 10);
            IIcon[] icons = new IIcon[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                icons[i] = IconSerializer.deserialize(list.func_150305_b(i));
            }
            return new CompoundIcon(icons);
        }

        @Override
        public CompoundNBT serialize(CompoundIcon icon) {
            ListNBT list = new ListNBT();
            CompoundNBT nbt = new CompoundNBT();
            for (IIcon i : icon.icons) {
                list.add((Object)i.getSerializer().serializeExt(i));
            }
            nbt.func_218657_a("Icons", (INBT)list);
            return nbt;
        }

        @Override
        public JsonObject serializeJson(CompoundIcon icon) {
            JsonArray jsonArray = new JsonArray();
            JsonObject jsonObject = new JsonObject();
            for (IIcon i : icon.icons) {
                jsonArray.add((JsonElement)i.getSerializer().serializeJsonExt(i));
            }
            jsonObject.add("icons", (JsonElement)jsonArray);
            return jsonObject;
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<String> getColumns() {
            return Arrays.asList("Setting", "Type", "Description", "Required", "Fallback Value");
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<Iterable<?>> getRows() {
            ArrayList rows = new ArrayList();
            rows.add(Arrays.asList("icons", IIcon[].class, "Array of icons that will be overlayed", true, null));
            return rows;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public JsonElement getExampleJson() {
            return this.serializeJsonExt(new CompoundIcon(new TexturedIcon(TexturedIcon.ICONS_TEXTURE, 0, 16, 16, 16), new ItemIcon(new ItemStack((IItemProvider)Items.field_221687_cF))));
        }
    }
}

