/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.icon;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.util.documentation.DocumentationBuilder;
import net.threetag.threecore.util.documentation.IDocumentationSettings;
import net.threetag.threecore.util.icon.CompoundIcon;
import net.threetag.threecore.util.icon.ExperienceIcon;
import net.threetag.threecore.util.icon.IIcon;
import net.threetag.threecore.util.icon.IIconSerializer;
import net.threetag.threecore.util.icon.ItemIcon;
import net.threetag.threecore.util.icon.TexturedIcon;

public class IconSerializer {
    private static Map<ResourceLocation, IIconSerializer> REGISTRY = Maps.newHashMap();

    public static <S extends IIconSerializer<T>, T extends IIcon> S register(S serializer) {
        if (REGISTRY.containsKey(serializer.getId())) {
            throw new IllegalArgumentException("Duplicate icon serializer " + serializer.getId());
        }
        REGISTRY.put(serializer.getId(), serializer);
        return serializer;
    }

    public static IIcon deserialize(JsonObject jsonObject) {
        ResourceLocation s = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"type"));
        IIconSerializer serializer = REGISTRY.get(s);
        if (serializer == null) {
            throw new JsonSyntaxException("Invalid or unsupported icon type '" + s + "'");
        }
        return serializer.read(jsonObject);
    }

    public static IIcon deserialize(CompoundNBT nbt) {
        ResourceLocation s = new ResourceLocation(nbt.func_74779_i("Type"));
        IIconSerializer serializer = REGISTRY.get(s);
        if (serializer == null) {
            return null;
        }
        return serializer.read(nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void generateDocumentation() {
        new DocumentationBuilder(new ResourceLocation("threecore", "icons"), "Icons").add(DocumentationBuilder.heading("Icons")).addDocumentationSettings(REGISTRY.values().stream().filter(serializer -> serializer instanceof IDocumentationSettings).map(serializer -> (IDocumentationSettings)((Object)serializer)).collect(Collectors.toList())).save();
    }

    static {
        IconSerializer.register(ItemIcon.Serializer.INSTANCE);
        IconSerializer.register(TexturedIcon.Serializer.INSTANCE);
        IconSerializer.register(ExperienceIcon.Serializer.INSTANCE);
        IconSerializer.register(CompoundIcon.Serializer.INSTANCE);
    }
}

