/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.util.documentation.IDocumentationSettings;
import net.threetag.threecore.util.icon.IIcon;
import net.threetag.threecore.util.icon.IIconSerializer;

public class ItemIcon
implements IIcon {
    public final ItemStack stack;

    public ItemIcon(ItemStack stack) {
        this.stack = stack;
    }

    public ItemIcon(IItemProvider itemProvider) {
        this.stack = new ItemStack(itemProvider);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(Minecraft mc, MatrixStack stack, int x, int y) {
        mc.func_175599_af().func_239390_c_(this.stack, x, y);
        if (this.stack.func_190916_E() > 1) {
            String text = this.stack.func_190916_E() + "x";
            mc.field_71466_p.func_238421_b_(stack, text, (float)(x + 9), (float)y + 8.0f, 0);
            mc.field_71466_p.func_238421_b_(stack, text, (float)(x + 7), (float)y + 8.0f, 0);
            mc.field_71466_p.func_238421_b_(stack, text, (float)x + 8.0f, (float)(y + 9), 0);
            mc.field_71466_p.func_238421_b_(stack, text, (float)x + 8.0f, (float)(y + 7), 0);
            mc.field_71466_p.func_238421_b_(stack, text, (float)x + 8.0f, (float)y + 8.0f, 0xFFFFFF);
        }
    }

    @Override
    public int getWidth() {
        return 16;
    }

    @Override
    public int getHeight() {
        return 16;
    }

    @Override
    public IIconSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIconSerializer<ItemIcon>,
    IDocumentationSettings {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("threecore", "item");

        @Override
        public ItemIcon read(JsonObject json) {
            return new ItemIcon(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
        }

        @Override
        public ItemIcon read(CompoundNBT nbt) {
            return new ItemIcon(ItemStack.func_199557_a((CompoundNBT)nbt));
        }

        @Override
        public CompoundNBT serialize(ItemIcon icon) {
            return icon.stack.serializeNBT();
        }

        @Override
        public JsonObject serializeJson(ItemIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)icon.stack.func_77973_b()).toString());
            jsonObject.addProperty("count", (Number)icon.stack.func_190916_E());
            return jsonObject;
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<String> getColumns() {
            return Arrays.asList("Setting", "Type", "Description", "Required", "Fallback Value");
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<Iterable<?>> getRows() {
            ArrayList rows = new ArrayList();
            rows.add(Arrays.asList("item", String.class, "Item ID", true, null));
            rows.add(Arrays.asList("count", Integer.class, "Item Amount", false, 1));
            return rows;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public JsonElement getExampleJson() {
            return this.serializeJsonExt(new ItemIcon(new ItemStack((IItemProvider)Items.field_151034_e)));
        }
    }
}

