/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.threedata;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.JSONUtils;
import net.threetag.threecore.util.threedata.ThreeData;

public class BodyPartListThreeData
extends ThreeData<List<BodyPart>> {
    public BodyPartListThreeData(String key) {
        super(key);
    }

    @Override
    public List<BodyPart> parseValue(JsonObject jsonObject, List<BodyPart> defaultValue) {
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)this.jsonKey)) {
            return defaultValue;
        }
        JsonElement jsonElement = jsonObject.get(this.jsonKey);
        return BodyPartListThreeData.parseBodyParts(jsonElement);
    }

    public static List<BodyPart> parseBodyParts(JsonElement jsonElement) {
        ArrayList list = Lists.newArrayList();
        if (jsonElement.isJsonPrimitive()) {
            BodyPart bodyPart = BodyPart.byName(jsonElement.getAsString());
            if (bodyPart == null) {
                throw new JsonSyntaxException("Body part " + jsonElement.getAsString() + " does not exist!");
            }
            list.add(bodyPart);
        } else if (jsonElement.isJsonArray()) {
            for (int i = 0; i < jsonElement.getAsJsonArray().size(); ++i) {
                BodyPart bodyPart = BodyPart.byName(jsonElement.getAsJsonArray().get(i).getAsString());
                if (bodyPart == null) {
                    throw new JsonSyntaxException("Body part " + jsonElement.getAsJsonArray().get(i).getAsString() + " does not exist!");
                }
                list.add(bodyPart);
            }
        } else {
            throw new JsonSyntaxException("Body part setting must be either a string or an array of strings!");
        }
        return list;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt, List<BodyPart> value) {
        ListNBT list = new ListNBT();
        for (BodyPart part : value) {
            list.add((Object)IntNBT.func_229692_a_((int)part.ordinal()));
        }
        nbt.func_218657_a(this.key, (INBT)list);
    }

    @Override
    public List<BodyPart> readFromNBT(CompoundNBT nbt, List<BodyPart> defaultValue) {
        if (!nbt.func_74764_b(this.key)) {
            return defaultValue;
        }
        ArrayList list = Lists.newArrayList();
        ListNBT listNBT = nbt.func_150295_c(this.key, 3);
        for (int i = 0; i < listNBT.size(); ++i) {
            BodyPart bodyPart = BodyPart.values()[listNBT.func_186858_c(i)];
            if (bodyPart == null) continue;
            list.add(bodyPart);
        }
        return list;
    }

    @Override
    public JsonElement serializeJson(List<BodyPart> value) {
        if (value.size() == 1) {
            return new JsonPrimitive(value.get(0).name);
        }
        JsonArray jsonArray = new JsonArray();
        for (BodyPart bodyPart : value) {
            jsonArray.add(bodyPart.name);
        }
        return jsonArray;
    }

    public static String getBodyPartList() {
        StringBuilder s = new StringBuilder();
        for (BodyPart part : BodyPart.values()) {
            s.append(", ").append(part.name);
        }
        return s.toString().substring(2);
    }

    public static enum BodyPart {
        HEAD("head"),
        HEAD_OVERLAY("head_overlay"),
        CHEST("chest"),
        CHEST_OVERLAY("chest_overlay"),
        RIGHT_ARM("right_arm"),
        RIGHT_ARM_OVERLAY("right_arm_overlay"),
        LEFT_ARM("left_arm"),
        LEFT_ARM_OVERLAY("left_arm_overlay"),
        RIGHT_LEG("right_leg"),
        RIGHT_LEG_OVERLAY("right_leg_overlay"),
        LEFT_LEG("left_leg"),
        LEFT_LEG_OVERLAY("left_leg_overlay");

        private String name;

        private BodyPart(String name) {
            this.name = name;
        }

        public void setVisibility(BipedModel<?> model, boolean visible) {
            boolean player = model instanceof PlayerModel;
            switch (this) {
                case HEAD: {
                    model.field_78116_c.field_78806_j = visible;
                    return;
                }
                case HEAD_OVERLAY: {
                    model.field_178720_f.field_78806_j = visible;
                    return;
                }
                case CHEST: {
                    model.field_78115_e.field_78806_j = visible;
                    return;
                }
                case CHEST_OVERLAY: {
                    if (player) {
                        ((PlayerModel)model).field_178730_v.field_78806_j = visible;
                    }
                    return;
                }
                case RIGHT_ARM: {
                    model.field_178723_h.field_78806_j = visible;
                    return;
                }
                case RIGHT_ARM_OVERLAY: {
                    if (player) {
                        ((PlayerModel)model).field_178732_b.field_78806_j = visible;
                    }
                    return;
                }
                case LEFT_ARM: {
                    model.field_178724_i.field_78806_j = visible;
                    return;
                }
                case LEFT_ARM_OVERLAY: {
                    if (player) {
                        ((PlayerModel)model).field_178734_a.field_78806_j = visible;
                    }
                    return;
                }
                case RIGHT_LEG: {
                    model.field_178721_j.field_78806_j = visible;
                    return;
                }
                case RIGHT_LEG_OVERLAY: {
                    if (player) {
                        ((PlayerModel)model).field_178731_d.field_78806_j = visible;
                    }
                    return;
                }
                case LEFT_LEG: {
                    model.field_178722_k.field_78806_j = visible;
                    return;
                }
            }
            if (player) {
                ((PlayerModel)model).field_178733_c.field_78806_j = visible;
            }
        }

        public static BodyPart byName(String name) {
            for (BodyPart bodyPart : BodyPart.values()) {
                if (!name.equalsIgnoreCase(bodyPart.name)) continue;
                return bodyPart;
            }
            return null;
        }
    }
}

