/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.threedata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.util.threedata.ThreeData;

public class EffectThreeData
extends ThreeData<Effect> {
    public EffectThreeData(String key) {
        super(key);
    }

    @Override
    public Effect parseValue(JsonObject jsonObject, Effect defaultValue) {
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)this.jsonKey)) {
            return defaultValue;
        }
        String potionKey = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)this.jsonKey);
        Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionKey));
        if (potion == null) {
            throw new JsonSyntaxException("Effect " + potionKey + " does not exist!");
        }
        return potion;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt, Effect value) {
        nbt.func_74778_a(this.key, ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)value).toString());
    }

    @Override
    public Effect readFromNBT(CompoundNBT nbt, Effect defaultValue) {
        if (!nbt.func_74764_b(this.key)) {
            return defaultValue;
        }
        Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(nbt.func_74779_i(this.key)));
        if (potion == null) {
            return defaultValue;
        }
        return potion;
    }

    @Override
    public JsonElement serializeJson(Effect value) {
        return new JsonPrimitive(ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)value).toString());
    }
}

