/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.threedata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.util.JSONUtils;
import net.threetag.threecore.util.threedata.ThreeData;

public class IntegerArrayThreeData
extends ThreeData<Integer[]> {
    public IntegerArrayThreeData(String key) {
        super(key);
    }

    @Override
    public Integer[] parseValue(JsonObject jsonObject, Integer[] defaultValue) {
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)this.jsonKey)) {
            return defaultValue;
        }
        JsonElement element = jsonObject.get(this.jsonKey);
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return new Integer[]{element.getAsInt()};
        }
        JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)this.jsonKey);
        Integer[] array = new Integer[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            array[i] = jsonArray.get(i).getAsInt();
        }
        return array;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt, Integer[] value) {
        nbt.func_218657_a(this.key, (INBT)new IntArrayNBT(Arrays.asList(value)));
    }

    @Override
    public Integer[] readFromNBT(CompoundNBT nbt, Integer[] defaultValue) {
        if (!nbt.func_74764_b(this.key)) {
            return defaultValue;
        }
        int[] array = nbt.func_74759_k(this.key);
        Integer[] integerArray = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            integerArray[i] = array[i];
        }
        return integerArray;
    }

    @Override
    public JsonElement serializeJson(Integer[] value) {
        if (value.length == 1) {
            return new JsonPrimitive((Number)value[0]);
        }
        JsonArray jsonArray = new JsonArray();
        for (Integer i : value) {
            jsonArray.add((Number)i);
        }
        return jsonArray;
    }
}

