/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.threedata;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.threetag.threecore.util.threedata.IThreeDataHolder;
import net.threetag.threecore.util.threedata.ThreeData;
import net.threetag.threecore.util.threedata.ThreeDataEntry;

public class ThreeDataManager
implements INBTSerializable<CompoundNBT>,
IThreeDataHolder {
    private Listener listener;
    protected Map<ThreeData<?>, ThreeDataEntry<?>> dataEntryList = new LinkedHashMap();

    public ThreeDataManager setListener(Listener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public <T> ThreeDataManager register(ThreeData<T> data, T defaultValue) {
        this.dataEntryList.put(data, new ThreeDataEntry<T>(data, defaultValue, defaultValue));
        return this;
    }

    @Override
    public <T> ThreeDataManager set(ThreeData<T> data, T value) {
        ThreeDataEntry<T> entry = this.getEntry(data);
        if (entry != null && !entry.getValue().equals(value)) {
            T oldValue = entry.getValue();
            entry.setValue(value);
            if (this.listener != null) {
                this.listener.dataChanged(data, oldValue, value);
            }
        }
        return this;
    }

    @Override
    public <T> T readValue(ThreeData<T> data, CompoundNBT nbt) {
        T newValue;
        T oldValue;
        ThreeDataEntry<T> entry = this.getEntry(data);
        if (entry != null && !(oldValue = entry.getValue()).equals(newValue = data.readFromNBT(nbt, entry.getDefaultValue()))) {
            entry.setValue(data.readFromNBT(nbt, newValue));
            if (this.listener != null) {
                this.listener.dataChanged(data, oldValue, newValue);
            }
            return newValue;
        }
        return null;
    }

    @Override
    public <T> T get(ThreeData<T> data) {
        ThreeDataEntry<T> entry = this.getEntry(data);
        return entry == null ? null : (T)entry.getValue();
    }

    @Override
    public <T> ThreeDataEntry<T> getEntry(ThreeData<T> data) {
        return this.dataEntryList.get(data);
    }

    public boolean has(ThreeData data) {
        return this.dataEntryList.containsKey(data);
    }

    @Override
    public <T> T getDefaultValue(ThreeData<T> data) {
        return (T)this.dataEntryList.get(data).getDefaultValue();
    }

    @Override
    public <T> ThreeDataManager reset(ThreeData<T> data) {
        this.set((ThreeData)data, (Object)this.getDefaultValue(data));
        return this;
    }

    public Set<ThreeData<?>> getData() {
        return this.dataEntryList.keySet();
    }

    public List<ThreeData<?>> getSettingData() {
        ArrayList list = new ArrayList();
        for (ThreeData<?> data : this.getData()) {
            if (!data.isUserSetting()) continue;
            list.add(data);
        }
        return list;
    }

    @Override
    public Collection<ThreeDataEntry<?>> getDataEntries() {
        return this.dataEntryList.values();
    }

    @Override
    public ThreeData<?> getDataByName(String name) {
        for (ThreeData<?> data : this.getData()) {
            if (!data.key.equals(name)) continue;
            return data;
        }
        return null;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        for (ThreeData<?> data : this.dataEntryList.keySet()) {
            ThreeDataEntry<?> entry;
            if (!data.canBeSaved() || (entry = this.getEntry(data)).holdsDefaultValue()) continue;
            data.writeToNBT(nbt, entry.getValue());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        for (ThreeData<?> data : this.dataEntryList.keySet()) {
            if (!data.canBeSaved()) continue;
            this.getEntry(data).setValue(data.readFromNBT(nbt, this.getDefaultValue(data)));
        }
    }

    public CompoundNBT getUpdatePacket() {
        CompoundNBT nbt = new CompoundNBT();
        for (ThreeData<?> data : this.dataEntryList.keySet()) {
            data.writeToNBT(nbt, this.getEntry(data).getValue());
        }
        return nbt;
    }

    public void readUpdatePacket(CompoundNBT nbt) {
        for (ThreeData<?> data : this.dataEntryList.keySet()) {
            this.getEntry(data).setValue(data.readFromNBT(nbt, this.getDefaultValue(data)));
        }
    }

    public void readFromJson(JsonObject jsonObject) {
        for (ThreeData<?> data : this.dataEntryList.keySet()) {
            this.getEntry(data).setValue(data.parseValue(jsonObject, this.getDefaultValue(data)));
        }
    }

    public static interface Listener {
        public <T> void dataChanged(ThreeData<T> var1, T var2, T var3);
    }
}

