/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech.ability;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.threetag.pymtech.ability.IAdvancedRegulatorAbility;
import net.threetag.pymtech.ability.PTAbilityTypes;
import net.threetag.pymtech.ability.RegulatorAbility;
import net.threetag.pymtech.client.icon.PymParticleIcon;
import net.threetag.pymtech.fluid.PTFluids;
import net.threetag.pymtech.item.PTItems;
import net.threetag.pymtech.sizechangetype.PTSizeChangeTypes;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.ability.container.IAbilityContainer;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.capability.ISizeChanging;
import net.threetag.threecore.fluid.ItemHandlerFluidHandler;
import net.threetag.threecore.util.threedata.FloatThreeData;
import net.threetag.threecore.util.threedata.StringThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class PymParticleSizeChangeAbility
extends Ability {
    public static final ThreeData<String> REGULATOR_ABILITY = new StringThreeData("regulator_ability").enableSetting("The id of the linked regulator ability to use pym particles from");
    public static final ThreeData<Float> SIZE = new FloatThreeData("size").enableSetting("The size this entity will change to");
    public static final Map<Fluid, Consumer<LivingEntity>> FLUID_ACTIONS = Maps.newHashMap();

    public PymParticleSizeChangeAbility() {
        super((AbilityType)PTAbilityTypes.PYM_PARTICLE_SIZE_CHANGE.get());
    }

    public void registerData() {
        super.registerData();
        this.dataManager.register(ICON, (Object)new PymParticleIcon(0.1f));
        this.dataManager.register(REGULATOR_ABILITY, (Object)"");
        this.dataManager.register(SIZE, (Object)Float.valueOf(0.1f));
    }

    public void action(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
                Ability linked = AbilityHelper.getAbilityById((LivingEntity)entity, (String)((String)this.dataManager.get(REGULATOR_ABILITY)), (IAbilityContainer)this.container);
                if (linked instanceof RegulatorAbility) {
                    RegulatorAbility regulatorAbility = (RegulatorAbility)linked;
                    float changeTo = this.getSize(entity);
                    float f = sizeChanging.getScale() - changeTo;
                    if (f != 0.0f) {
                        ItemHandlerFluidHandler fluidHandler = new ItemHandlerFluidHandler((IItemHandler)regulatorAbility.itemHandler);
                        ItemStack regulator = regulatorAbility.itemHandler.getStackInSlot(0);
                        if (!regulator.func_190926_b()) {
                            float size;
                            boolean grow;
                            boolean bl = grow = regulator.func_77973_b() == PTItems.ENLARGE_DISK.get() && f >= 0.0f;
                            if (grow || regulator.func_77973_b() == PTItems.SHRINK_DISK.get() && f <= 0.0f || regulator.func_190926_b() && f <= 0.0f) {
                                return;
                            }
                            FluidStack toDrain = new FluidStack(f > 0.0f ? PTFluids.SHRINK_PYM_PARTICLES : PTFluids.ENLARGE_PYM_PARTICLES, 250);
                            FluidStack drained = fluidHandler.drain(toDrain, IFluidHandler.FluidAction.SIMULATE);
                            float f2 = size = regulator.func_190926_b() ? 0.1f : changeTo;
                            if (!drained.isEmpty() && drained.getAmount() == 250) {
                                if (sizeChanging.startSizeChange(PTSizeChangeTypes.PYM_PARTICLES, size)) {
                                    fluidHandler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE).getAmount();
                                }
                            } else {
                                for (Fluid fluid : FLUID_ACTIONS.keySet()) {
                                    FluidStack drained2 = fluidHandler.drain(new FluidStack(fluid, 500), IFluidHandler.FluidAction.EXECUTE);
                                    if (drained2.isEmpty()) continue;
                                    FLUID_ACTIONS.get(fluid).accept(entity);
                                    return;
                                }
                                if (entity instanceof PlayerEntity) {
                                    ((PlayerEntity)entity).func_146105_b((ITextComponent)new TranslationTextComponent(f > 0.0f ? "ability.pymtech.pym_particle_size_change.not_enough_shrink_particles" : "ability.pymtech.pym_particle_size_change.not_enough_enlarge_particles"), true);
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    public float getSize(LivingEntity entity) {
        float customSize;
        if (entity == null || !entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING, null).isPresent()) {
            return 1.0f;
        }
        float playerSize = ((ISizeChanging)entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING, null).orElse(null)).getScale();
        Ability linked = AbilityHelper.getAbilityById((LivingEntity)entity, (String)((String)this.get(REGULATOR_ABILITY)), (IAbilityContainer)this.getContainer());
        float abilitySize = ((Float)this.get(SIZE)).floatValue();
        float f = customSize = linked instanceof IAdvancedRegulatorAbility ? ((IAdvancedRegulatorAbility)linked).getRegulatedSize() : 0.0f;
        if (playerSize < 1.0f && abilitySize > 1.0f || playerSize > 1.0f && abilitySize < 1.0f) {
            return 1.0f;
        }
        if (customSize <= 0.0f) {
            return abilitySize;
        }
        return customSize < 1.0f && abilitySize < 1.0f ? customSize : (customSize > 1.0f && abilitySize > 1.0f ? customSize : abilitySize);
    }

    static {
        FLUID_ACTIONS.put((Fluid)Fluids.field_204546_a, entity -> {
            boolean flag1;
            boolean bl = flag1 = entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75102_a;
            if (!(entity.func_70648_aU() || EffectUtils.func_205133_c((LivingEntity)entity) || flag1)) {
                entity.func_70050_g(0);
                entity.func_70097_a(DamageSource.field_76369_e, 8.0f);
            }
        });
        FLUID_ACTIONS.put((Fluid)Fluids.field_204547_b, entity -> entity.func_70015_d(10));
    }
}

