/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech.client.icon;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.pymtech.ability.PymParticleSizeChangeAbility;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.capability.ISizeChanging;
import net.threetag.threecore.util.RenderUtil;
import net.threetag.threecore.util.icon.IIcon;
import net.threetag.threecore.util.icon.IIconSerializer;
import net.threetag.threecore.util.icon.IconSerializer;

public class PymParticleIcon
implements IIcon {
    public static final ResourceLocation TEXTURE = new ResourceLocation("pymtech", "textures/gui/icons.png");
    private final float size;

    public PymParticleIcon(float size) {
        this.size = size;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(Minecraft minecraft, MatrixStack matrixStack, int x, int y) {
        float currentSize;
        minecraft.func_110434_K().func_110577_a(TEXTURE);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        float changeToSize = RenderUtil.getCurrentAbilityInIconRendering() instanceof PymParticleSizeChangeAbility ? ((PymParticleSizeChangeAbility)RenderUtil.getCurrentAbilityInIconRendering()).getSize((LivingEntity)minecraft.field_71439_g) : 1.0f;
        float f = currentSize = minecraft.field_71439_g != null && minecraft.field_71439_g.getCapability(CapabilitySizeChanging.SIZE_CHANGING).isPresent() ? ((ISizeChanging)minecraft.field_71439_g.getCapability(CapabilitySizeChanging.SIZE_CHANGING).orElse(null)).getScale() : 1.0f;
        if (changeToSize < 1.0f) {
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)(changeToSize <= currentSize ? 0.0f : 32.0f), (float)0.0f, (int)32, (int)32, (int)256, (int)256);
        } else {
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)(changeToSize < currentSize ? 0.0f : 32.0f), (float)0.0f, (int)32, (int)32, (int)256, (int)256);
        }
        String s = "" + changeToSize;
        int length = minecraft.field_71466_p.func_78256_a(s);
        minecraft.field_71466_p.func_238421_b_(matrixStack, s, 16.0f - (float)length / 2.0f, 25.0f, 0xFEFEFE);
        RenderSystem.popMatrix();
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }

    public IIconSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    static {
        IconSerializer.register((IIconSerializer)Serializer.INSTANCE);
    }

    public static class Serializer
    implements IIconSerializer<PymParticleIcon> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pymtech", "pym_particles");

        public PymParticleIcon read(JsonObject json) {
            return new PymParticleIcon(JSONUtils.func_151217_k((JsonObject)json, (String)"size"));
        }

        public PymParticleIcon read(CompoundNBT nbt) {
            return new PymParticleIcon(nbt.func_74760_g("Size"));
        }

        public CompoundNBT serialize(PymParticleIcon icon) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74776_a("Size", icon.size);
            return nbt;
        }

        public JsonObject serializeJson(PymParticleIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("size", (Number)Float.valueOf(icon.size));
            return jsonObject;
        }

        public ResourceLocation getId() {
            return ID;
        }
    }
}

