/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.block;

import java.util.Locale;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlimeBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.api.IConditionalSticky;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.Module;

public class ColorSlimeBlock
extends SlimeBlock
implements IConditionalSticky {
    private final SlimeColor color;
    private final Module module;

    public ColorSlimeBlock(SlimeColor color, Module module) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_180399_cE));
        RegistryHelper.registerBlock((Block)this, (String)(color.name().toLowerCase(Locale.ROOT) + "_slime_block"));
        RegistryHelper.setCreativeTab((Block)this, (ItemGroup)ItemGroup.field_78031_c);
        this.color = color;
        this.module = module;
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.TRANSLUCENT);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.module.enabled || group == ItemGroup.field_78027_g) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    public boolean canStickToBlock(World world, BlockPos pistonPos, BlockPos pos, BlockPos slimePos, BlockState state, BlockState slimeState, Direction direction) {
        SlimeColor otherColor;
        SlimeColor ourColor = this.color;
        Block block = slimeState.func_177230_c();
        if (block instanceof ColorSlimeBlock && !ourColor.sticksTo(otherColor = ((ColorSlimeBlock)block).color) && ourColor != otherColor) {
            return false;
        }
        if (block == Blocks.field_180399_cE) {
            return ourColor.sticksToGreen;
        }
        return true;
    }

    public boolean isStickyBlock(BlockState state) {
        return true;
    }

    public static enum SlimeColor {
        RED(MaterialColor.field_151645_D, false, 3, 4),
        BLUE(MaterialColor.field_151649_A, false, 2, 3),
        CYAN(MaterialColor.field_151679_y, true, 1),
        MAGENTA(MaterialColor.field_151675_r, false, 0, 1),
        YELLOW(MaterialColor.field_151673_t, true, 0);

        public final MaterialColor color;
        public final boolean sticksToGreen;
        private final int[] sticksTo;

        private SlimeColor(MaterialColor color, boolean sticksToGreen, int ... sticksTo) {
            this.color = color;
            this.sticksToGreen = sticksToGreen;
            this.sticksTo = sticksTo;
        }

        public boolean sticksTo(SlimeColor otherVariant) {
            int ord = otherVariant.ordinal();
            for (int i : this.sticksTo) {
                if (i != ord) continue;
                return true;
            }
            return false;
        }
    }
}

