/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.module;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.automation.block.FeedingTroughBlock;
import vazkii.quark.automation.tile.FeedingTroughTileEntity;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.AUTOMATION, hasSubscriptions=true)
public class FeedingTroughModule
extends Module {
    public static TileEntityType<FeedingTroughTileEntity> tileEntityType;
    @Config(description="How long, in game ticks, between animals being able to eat from the trough")
    @Config.Min(value=1.0)
    public static int cooldown;
    @Config(description="The maximum amount of animals allowed around the trough's range for an animal to enter love mode")
    public static int maxAnimals;
    @Config(description="The chance (between 0 and 1) for an animal to enter love mode when eating from the trough")
    @Config.Min(value=0.0, exclusive=true)
    @Config.Max(value=1.0)
    public static double loveChance;
    @Config
    public static double range;
    private static final ThreadLocal<Set<FeedingTroughTileEntity>> loadedTroughs;
    private static final ThreadLocal<Boolean> breedingOccurred;

    @SubscribeEvent
    public void buildTroughSet(TickEvent.WorldTickEvent event) {
        Set<FeedingTroughTileEntity> troughs = loadedTroughs.get();
        if (event.side == LogicalSide.SERVER) {
            if (event.phase == TickEvent.Phase.START) {
                breedingOccurred.remove();
                for (TileEntity tile : event.world.field_147482_g) {
                    if (!(tile instanceof FeedingTroughTileEntity)) continue;
                    troughs.add((FeedingTroughTileEntity)tile);
                }
            } else {
                troughs.clear();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreed(BabyEntitySpawnEvent event) {
        if (event.getCausedByPlayer() == null && event.getParentA().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            breedingOccurred.set(true);
        }
    }

    @SubscribeEvent
    public void onOrbSpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ExperienceOrbEntity && breedingOccurred.get().booleanValue()) {
            event.setCanceled(true);
            breedingOccurred.remove();
        }
    }

    public static PlayerEntity temptWithTroughs(TemptGoal goal, PlayerEntity found) {
        Vector3d targetPos;
        Vector3d eyesPos;
        BlockRayTraceResult ray;
        if (!ModuleLoader.INSTANCE.isModuleEnabled(FeedingTroughModule.class) || found != null && (goal.func_188508_a(found.func_184614_ca()) || goal.func_188508_a(found.func_184592_cb()))) {
            return found;
        }
        if (!(goal.field_75284_a instanceof AnimalEntity) || !((AnimalEntity)goal.field_75284_a).func_204701_dC() || ((AnimalEntity)goal.field_75284_a).func_70874_b() != 0) {
            return found;
        }
        double shortestDistanceSq = Double.MAX_VALUE;
        BlockPos location = null;
        FakePlayer target = null;
        Set<FeedingTroughTileEntity> troughs = loadedTroughs.get();
        for (FeedingTroughTileEntity tile : troughs) {
            FakePlayer foodHolder;
            BlockPos pos = tile.func_174877_v();
            double distanceSq = pos.func_218138_a((IPosition)goal.field_75284_a.func_213303_ch(), true);
            if (!(distanceSq <= range * range) || !(distanceSq < shortestDistanceSq) || (foodHolder = tile.getFoodHolder(goal)) == null) continue;
            shortestDistanceSq = distanceSq;
            target = foodHolder;
            location = pos.func_185334_h();
        }
        if (target != null && (ray = goal.field_75284_a.field_70170_p.func_217299_a(new RayTraceContext(eyesPos = goal.field_75284_a.func_213303_ch().func_72441_c(0.0, (double)goal.field_75284_a.func_70047_e(), 0.0), targetPos = new Vector3d((double)location.func_177958_n(), (double)location.func_177956_o(), (double)location.func_177952_p()).func_72441_c(0.5, 0.0625, 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)goal.field_75284_a))).func_216346_c() == RayTraceResult.Type.BLOCK && ray.func_216350_a().equals((Object)location)) {
            return target;
        }
        return found;
    }

    @Override
    public void construct() {
        FeedingTroughBlock feedingTrough = new FeedingTroughBlock("feeding_trough", this, ItemGroup.field_78031_c, AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(0.6f).func_200947_a(SoundType.field_185848_a));
        tileEntityType = TileEntityType.Builder.func_223042_a(FeedingTroughTileEntity::new, (Block[])new Block[]{feedingTrough}).func_206865_a(null);
        RegistryHelper.register(tileEntityType, (String)"feeding_trough");
    }

    static {
        cooldown = 30;
        maxAnimals = 32;
        loveChance = 0.333333333;
        range = 10.0;
        loadedTroughs = ThreadLocal.withInitial(HashSet::new);
        breedingOccurred = ThreadLocal.withInitial(() -> false);
    }
}

