/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.block;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.WallBlock;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.Module;

public class QuarkWallBlock
extends WallBlock
implements IQuarkBlock,
IBlockColorProvider {
    private final IQuarkBlock parent;
    private BooleanSupplier enabledSupplier = () -> true;

    public QuarkWallBlock(IQuarkBlock parent) {
        super(VariantHandler.realStateCopy(parent));
        this.parent = parent;
        RegistryHelper.registerBlock((Block)this, (String)(Objects.toString(parent.getBlock().getRegistryName()) + "_wall"));
        RegistryHelper.setCreativeTab((Block)this, (ItemGroup)ItemGroup.field_78031_c);
        RenderLayerHandler.setInherited((Block)this, parent.getBlock());
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78027_g || this.parent.isEnabled()) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.parent.getModule();
    }

    @Override
    public QuarkWallBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        return this.parent.getBlock().getBeaconColorMultiplier(this.parent.getBlock().func_176223_P(), world, pos, beaconPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBlockColor getBlockColor() {
        return this.parent instanceof IBlockColorProvider ? ((IBlockColorProvider)this.parent).getBlockColor() : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IItemColor getItemColor() {
        return this.parent instanceof IItemColorProvider ? ((IItemColorProvider)this.parent).getItemColor() : null;
    }
}

