/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config;

import java.io.PrintStream;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import vazkii.quark.base.client.config.AbstractConfigElement;
import vazkii.quark.base.client.config.ConfigCategory;
import vazkii.quark.base.client.config.IConfigElement;
import vazkii.quark.base.client.config.obj.BooleanObject;
import vazkii.quark.base.client.config.obj.DoubleObject;
import vazkii.quark.base.client.config.obj.IntegerObject;
import vazkii.quark.base.client.config.obj.ListObject;
import vazkii.quark.base.client.config.obj.StringObject;

public abstract class ConfigObject<T>
extends AbstractConfigElement {
    public final T defaultObj;
    public final Predicate<Object> restriction;
    protected final Supplier<T> objectGetter;
    protected final String displayName;
    protected T loadedObj;
    protected T currentObj;

    public ConfigObject(String name, String comment, T defaultObj, Supplier<T> objGetter, Predicate<Object> restriction, ConfigCategory parent) {
        super(name, comment, parent);
        this.defaultObj = defaultObj;
        this.objectGetter = objGetter;
        this.restriction = restriction;
        this.displayName = name.contains(" ") ? String.format("\"%s\"", name) : name;
    }

    public static <T> ConfigObject<?> create(String name, String comment, T defaultObj, Supplier<T> objGetter, Predicate<Object> restriction, ConfigCategory parent) {
        if (defaultObj instanceof Boolean) {
            return new BooleanObject(name, comment, (Boolean)defaultObj, objGetter, restriction, parent);
        }
        if (defaultObj instanceof String) {
            return new StringObject(name, comment, (String)defaultObj, objGetter, restriction, parent);
        }
        if (defaultObj instanceof Integer) {
            return new IntegerObject(name, comment, (Integer)defaultObj, objGetter, restriction, parent);
        }
        if (defaultObj instanceof Double) {
            return new DoubleObject(name, comment, (Double)defaultObj, objGetter, restriction, parent);
        }
        if (defaultObj instanceof List) {
            return new ListObject(name, comment, (List)defaultObj, objGetter, restriction, parent);
        }
        throw new IllegalArgumentException(defaultObj + " isn't a valid config object.");
    }

    @Override
    public String getGuiDisplayName() {
        return this.name;
    }

    @Override
    public void refresh() {
        this.currentObj = this.objectGetter.get();
        this.loadedObj = this.currentObj;
    }

    @Override
    public void clean() {
        this.loadedObj = this.currentObj;
    }

    @Override
    public void reset(boolean hard) {
        this.setCurrentObj(hard ? this.defaultObj : this.loadedObj);
    }

    public T getCurrentObj() {
        return this.currentObj;
    }

    public void setCurrentObj(T currentObj) {
        this.currentObj = currentObj;
        this.parent.updateDirty();
    }

    @Override
    public String getSubtitle() {
        String str = this.currentObj.toString();
        if (str.length() > 30) {
            str = str.substring(0, 27) + "...";
        }
        return str;
    }

    @Override
    public boolean isDirty() {
        return this.wouldBeDirty(this.currentObj);
    }

    public boolean wouldBeDirty(T testObject) {
        return !this.loadedObj.equals(testObject);
    }

    @Override
    public void print(String pad, PrintStream out) {
        super.print(pad, out);
        String objStr = this.computeObjectString();
        out.printf("%s%s = %s%n", pad, this.displayName, objStr);
    }

    protected String computeObjectString() {
        return this.currentObj.toString();
    }

    @Override
    public int compareTo(IConfigElement o) {
        if (o == this) {
            return 0;
        }
        if (!(o instanceof ConfigObject)) {
            return -1;
        }
        return this.name.compareTo(((ConfigObject)o).name);
    }
}

