/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.config.ConfigObjectSerializer;
import vazkii.quark.base.module.config.IConfigBuilder;
import vazkii.quark.base.module.config.IConfigCallback;
import vazkii.quark.base.module.config.QuarkConfigBuilder;

public class ConfigResolver {
    private final ConfigFlagManager flagManager;
    private List<Runnable> refreshRunnables = new LinkedList<Runnable>();

    public ConfigResolver() {
        this.flagManager = new ConfigFlagManager();
    }

    public void makeSpec() {
        ForgeConfigSpec.Builder forgeBuilder = new ForgeConfigSpec.Builder();
        IConfigCallback callback = Quark.proxy.getConfigCallback();
        QuarkConfigBuilder builder = new QuarkConfigBuilder(forgeBuilder, callback);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, builder.configure(this::build));
    }

    public void configChanged() {
        this.flagManager.clear();
        this.refreshRunnables.forEach(Runnable::run);
    }

    private Void build(IConfigBuilder builder) {
        builder.push("general");
        try {
            ConfigObjectSerializer.serialize(builder, this.flagManager, this.refreshRunnables, GeneralConfig.INSTANCE);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create quark general config", e);
        }
        builder.pop();
        builder.push("categories");
        this.buildCategoryList(builder);
        builder.pop();
        for (ModuleCategory category : ModuleCategory.values()) {
            this.buildCategory(builder, category);
        }
        return null;
    }

    private void buildCategoryList(IConfigBuilder builder) {
        for (ModuleCategory category : ModuleCategory.values()) {
            ForgeConfigSpec.ConfigValue<Boolean> value = builder.defineBool(WordUtils.capitalizeFully((String)category.name), () -> category.enabled, true);
            this.refreshRunnables.add(() -> {
                category.enabled = (Boolean)value.get();
            });
        }
    }

    private void buildCategory(IConfigBuilder builder, ModuleCategory category) {
        builder.push(category.name);
        List<Module> modules = category.getOwnedModules();
        HashMap<Module, Runnable> setEnabledRunnables = new HashMap<Module, Runnable>();
        for (Module module : modules) {
            ForgeConfigSpec.ConfigValue<Boolean> value = builder.defineBool(module.displayName, () -> module.configEnabled, module.enabledByDefault);
            setEnabledRunnables.put(module, () -> {
                module.setEnabled((Boolean)value.get() != false && category.enabled);
                this.flagManager.putEnabledFlag(module);
            });
        }
        for (Module module : modules) {
            this.buildModule(builder, module, (Runnable)setEnabledRunnables.get(module));
        }
        builder.pop();
    }

    private void buildModule(IConfigBuilder builder, Module module, Runnable setEnabled) {
        if (!module.description.isEmpty()) {
            builder.comment(module.description);
        }
        builder.push(module.lowercaseName);
        if (module.antiOverlap != null && module.antiOverlap.size() > 0) {
            this.addModuleAntiOverlap(builder, module);
        }
        this.refreshRunnables.add(setEnabled);
        try {
            ConfigObjectSerializer.serialize(builder, this.flagManager, this.refreshRunnables, module);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create config spec for module " + module.displayName, e);
        }
        this.refreshRunnables.add(() -> module.pushFlags(this.flagManager));
        builder.pop();
    }

    private void addModuleAntiOverlap(IConfigBuilder builder, Module module) {
        StringBuilder desc = new StringBuilder("This feature disables itself if any of the following mods are loaded: \n");
        for (String s : module.antiOverlap) {
            desc.append(" - ").append(s).append("\n");
        }
        desc.append("This is done to prevent content overlap.\nYou can turn this on to force the feature to be loaded even if the above mods are also loaded.");
        String descStr = desc.toString();
        builder.comment(descStr);
        ForgeConfigSpec.ConfigValue<Boolean> value = builder.defineBool("Ignore Anti Overlap", () -> module.ignoreAntiOverlap, false);
        this.refreshRunnables.add(() -> {
            module.ignoreAntiOverlap = !GeneralConfig.useAntiOverlap || (Boolean)value.get() != false;
        });
    }
}

