/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import vazkii.quark.base.module.config.IConfigBuilder;
import vazkii.quark.base.module.config.IConfigCallback;

public class QuarkConfigBuilder
implements IConfigBuilder {
    private final ForgeConfigSpec.Builder parent;
    private final IConfigCallback callback;
    private String currComment = "";

    public QuarkConfigBuilder(ForgeConfigSpec.Builder parent, IConfigCallback callback) {
        this.parent = parent;
        this.callback = callback;
    }

    @Override
    public <T> ForgeConfigSpec configure(Function<IConfigBuilder, T> func) {
        return (ForgeConfigSpec)this.parent.configure(b -> func.apply(this)).getRight();
    }

    @Override
    public void push(String s) {
        this.parent.push(s);
        this.callback.push(s, this.currComment);
        this.currComment = "";
    }

    @Override
    public void pop() {
        this.parent.pop();
        this.callback.pop();
    }

    @Override
    public void comment(String s) {
        this.currComment = this.currComment + s;
    }

    @Override
    public ForgeConfigSpec.ConfigValue<?> defineList(String name, List<?> default_, Supplier<Object> getter, Predicate<Object> predicate) {
        this.onDefine(name, default_, getter, predicate);
        return this.parent.defineList(name, default_, predicate);
    }

    @Override
    public ForgeConfigSpec.ConfigValue<?> defineObj(String name, Object default_, Supplier<Object> getter, Predicate<Object> predicate) {
        this.onDefine(name, default_, getter, predicate);
        return this.parent.define(name, default_, predicate);
    }

    @Override
    public ForgeConfigSpec.ConfigValue<Boolean> defineBool(String name, Supplier<Boolean> getter, boolean default_) {
        this.onDefine(name, default_, getter, (Predicate<Object>)Predicates.alwaysTrue());
        return this.parent.define(name, default_);
    }

    @Override
    public ForgeConfigSpec.ConfigValue<Integer> defineInt(String name, Supplier<Integer> getter, int default_) {
        this.onDefine(name, default_, getter, (Predicate<Object>)Predicates.alwaysTrue());
        return this.parent.define(name, (Object)default_);
    }

    @Override
    public ForgeConfigSpec.ConfigValue<Double> defineDouble(String name, Supplier<Double> getter, double default_) {
        this.onDefine(name, default_, getter, (Predicate<Object>)Predicates.alwaysTrue());
        return this.parent.define(name, (Object)default_);
    }

    private <T> void onDefine(String name, T default_, Supplier<T> getter, Predicate<Object> predicate) {
        if (this.currComment.length() > 0) {
            this.parent.comment(this.currComment);
        }
        this.callback.addEntry(name, default_, getter, this.currComment, predicate);
        this.currComment = "";
    }
}

