/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.quark.building.module.ItemFramesModule;

public class GlassItemFrameEntity
extends ItemFrameEntity
implements IEntityAdditionalSpawnData {
    private boolean didHackery = false;

    public GlassItemFrameEntity(EntityType<? extends GlassItemFrameEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public GlassItemFrameEntity(World worldIn, BlockPos blockPos, Direction face) {
        super(ItemFramesModule.glassFrameEntity, worldIn);
        this.field_174861_a = blockPos;
        this.func_174859_a(face);
    }

    public boolean func_70518_d() {
        return super.func_70518_d() || this.isOnSign();
    }

    public BlockPos getBehindPos() {
        return this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
    }

    public boolean isOnSign() {
        BlockState blockstate = this.field_70170_p.func_180495_p(this.getBehindPos());
        return blockstate.func_177230_c().func_203417_a((ITag)BlockTags.field_219751_T);
    }

    @Nullable
    public ItemEntity func_70099_a(@Nonnull ItemStack stack, float offset) {
        if (stack.func_77973_b() == Items.field_151160_bD && !this.didHackery) {
            stack = new ItemStack((IItemProvider)ItemFramesModule.glassFrame);
            this.didHackery = true;
        }
        return super.func_70099_a(stack, offset);
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack held = this.func_82335_i();
        if (held.func_190926_b()) {
            return new ItemStack((IItemProvider)ItemFramesModule.glassFrame);
        }
        return held.func_77946_l();
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179255_a(this.field_174861_a);
        buffer.func_150787_b(this.field_174860_b.func_176745_a());
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.field_174861_a = buffer.func_179259_c();
        this.func_174859_a(Direction.func_82600_a((int)buffer.func_150792_a()));
    }
}

