/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.module;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import vazkii.quark.base.handler.FuelHandler;
import vazkii.quark.base.handler.ItemOverrideHandler;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.building.block.IronLadderBlock;
import vazkii.quark.building.block.VariantLadderBlock;

@LoadModule(category=ModuleCategory.BUILDING)
public class VariantLaddersModule
extends Module {
    @Config
    public static boolean changeNames = true;
    @Config(flag="iron_ladder")
    public static boolean enableIronLadder = true;
    public static List<Block> variantLadders = new LinkedList<Block>();
    public static Block iron_ladder;
    public static boolean moduleEnabled;

    @Override
    public void construct() {
        for (String type : MiscUtil.OVERWORLD_VARIANT_WOOD_TYPES) {
            variantLadders.add((Block)new VariantLadderBlock(type, this, true));
        }
        for (String type : MiscUtil.NETHER_WOOD_TYPES) {
            variantLadders.add((Block)new VariantLadderBlock(type, this, false));
        }
        iron_ladder = new IronLadderBlock(this);
    }

    @Override
    public void loadComplete() {
        variantLadders.forEach(FuelHandler::addWood);
    }

    @Override
    public void configChanged() {
        moduleEnabled = this.enabled;
        ItemOverrideHandler.changeBlockLocalizationKey(Blocks.field_150468_ap, "block.quark.oak_ladder", changeNames && this.enabled);
    }

    public static boolean isTrapdoorLadder(boolean defaultValue, IWorldReader world, BlockPos pos) {
        BlockState down;
        if (defaultValue || !moduleEnabled) {
            return defaultValue;
        }
        BlockState curr = world.func_180495_p(pos);
        if (((Boolean)curr.func_177229_b((Property)TrapDoorBlock.field_176283_b)).booleanValue() && (down = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof LadderBlock) {
            return down.func_177229_b((Property)LadderBlock.field_176382_a) == curr.func_177229_b((Property)TrapDoorBlock.field_185512_D);
        }
        return false;
    }
}

