/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.module;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.api.IQuarkButtonIgnored;
import vazkii.quark.base.client.InventoryButtonHandler;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.handler.InventoryTransferHandler;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.SimilarBlockTypeHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.management.client.gui.MiniInventoryButton;

@LoadModule(category=ModuleCategory.CLIENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class ChestSearchingModule
extends Module {
    @OnlyIn(value=Dist.CLIENT)
    private static TextFieldWidget searchBar;
    private static String text;
    private static boolean searchEnabled;
    private static long lastClick;
    private static int matched;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        InventoryButtonHandler.addButtonProvider(this, InventoryButtonHandler.ButtonTargetType.CONTAINER_INVENTORY, 1, (parent, x, y) -> new MiniInventoryButton(parent, 3, x, y, "quark.gui.button.filter", b -> {
            searchEnabled = !searchEnabled;
            this.updateSearchStatus();
        }).setTextureShift(() -> searchEnabled));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen gui = event.getGui();
        if (gui instanceof ContainerScreen && !(event.getGui() instanceof IQuarkButtonIgnored) && !GeneralConfig.ignoredScreens.contains(event.getGui().getClass().getName())) {
            Minecraft mc = gui.getMinecraft();
            ContainerScreen chest = (ContainerScreen)gui;
            if (InventoryTransferHandler.accepts(chest.func_212873_a_(), (PlayerEntity)mc.field_71439_g)) {
                searchBar = new TextFieldWidget(mc.field_71466_p, chest.getGuiLeft() + 18, chest.getGuiTop() + 6, 117, 10, (ITextComponent)new StringTextComponent(text));
                searchBar.func_146180_a(text);
                searchBar.func_146203_f(50);
                searchBar.func_146185_a(false);
                this.updateSearchStatus();
                return;
            }
        }
        searchBar = null;
    }

    private void updateSearchStatus() {
        searchBar.func_146184_c(searchEnabled);
        searchBar.func_146189_e(searchEnabled);
        searchBar.func_146195_b(searchEnabled);
    }

    @SubscribeEvent
    public void charTyped(GuiScreenEvent.KeyboardCharTypedEvent.Pre event) {
        if (searchBar != null && searchBar.func_230999_j_() && searchEnabled) {
            searchBar.func_231042_a_(event.getCodePoint(), event.getModifiers());
            text = searchBar.func_146179_b();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onKeypress(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (searchBar != null && searchBar.func_230999_j_() && searchEnabled) {
            searchBar.func_231046_a_(event.getKeyCode(), event.getScanCode(), event.getModifiers());
            text = searchBar.func_146179_b();
            event.setCanceled(event.getKeyCode() != 256);
        }
    }

    @SubscribeEvent
    public void onClick(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (searchBar != null && searchEnabled) {
            searchBar.func_231044_a_(event.getMouseX(), event.getMouseY(), event.getButton());
            long time = System.currentTimeMillis();
            long delta = time - lastClick;
            if (delta < 200L && searchBar.func_230999_j_()) {
                searchBar.func_146180_a("");
                text = "";
            }
            lastClick = time;
        }
    }

    @SubscribeEvent
    public void onRender(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (searchBar != null && searchEnabled) {
            this.renderElements(event.getMatrixStack(), event.getGui());
        }
    }

    private void renderElements(MatrixStack matrix, Screen gui) {
        RenderSystem.pushMatrix();
        this.drawBackground(matrix, gui, ChestSearchingModule.searchBar.field_230690_l_ - 11, ChestSearchingModule.searchBar.field_230691_m_ - 3);
        if (!text.isEmpty() && gui instanceof ContainerScreen) {
            ContainerScreen guiContainer = (ContainerScreen)gui;
            Container container = guiContainer.func_212873_a_();
            int guiLeft = guiContainer.getGuiLeft();
            int guiTop = guiContainer.getGuiTop();
            matched = 0;
            for (Slot s : container.field_75151_b) {
                ItemStack stack = s.func_75211_c();
                if (!ChestSearchingModule.namesMatch(stack, text)) {
                    int x = guiLeft + s.field_75223_e;
                    int y = guiTop + s.field_75221_f;
                    RenderSystem.disableDepthTest();
                    Screen.func_238467_a_((MatrixStack)matrix, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-1442840576);
                    continue;
                }
                ++matched;
            }
        }
        if (matched == 0 && !text.isEmpty()) {
            searchBar.func_146193_g(0xFF5555);
        } else {
            searchBar.func_146193_g(0xFFFFFF);
        }
        searchBar.func_230430_a_(matrix, 0, 0, 0.0f);
        RenderSystem.popMatrix();
    }

    private void drawBackground(MatrixStack matrix, Screen gui, int x, int y) {
        if (gui == null) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(MiscUtil.GENERAL_ICONS);
        Screen.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)126, (int)13, (int)256, (int)256);
    }

    public static boolean namesMatch(ItemStack stack) {
        return !searchEnabled || ChestSearchingModule.namesMatch(stack, text);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean namesMatch(ItemStack stack, String search) {
        CompoundNBT cmp;
        if ((search = TextFormatting.func_110646_a((String)search.trim().toLowerCase(Locale.ROOT))) == null || search.isEmpty()) {
            return true;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        ResourceLocation res = item.getRegistryName();
        if (SimilarBlockTypeHandler.isShulkerBox(res) && (cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)"BlockEntityTag", (boolean)true)) != null) {
            LazyOptional handler;
            TileEntity te;
            if (!cmp.func_150297_b("id", 8)) {
                cmp = cmp.func_74737_b();
                cmp.func_74778_a("id", "minecraft:shulker_box");
            }
            if ((te = TileEntity.func_235657_b_((BlockState)((BlockItem)item).func_179223_d().func_176223_P(), (CompoundNBT)cmp)) != null && (handler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).isPresent()) {
                void var8_9;
                IItemHandler items = (IItemHandler)handler.orElseGet(EmptyHandler::new);
                boolean bl = false;
                while (var8_9 < items.getSlots()) {
                    if (ChestSearchingModule.namesMatch(items.getStackInSlot((int)var8_9), search)) {
                        return true;
                    }
                    ++var8_9;
                }
            }
        }
        String name = stack.func_200301_q().getString();
        name = TextFormatting.func_110646_a((String)name.trim().toLowerCase(Locale.ROOT));
        StringMatcher matcher = String::contains;
        if (search.length() >= 3 && search.startsWith("\"") && search.endsWith("\"")) {
            search = search.substring(1, search.length() - 1);
            matcher = String::equals;
        }
        if (search.length() >= 3 && search.startsWith("/") && search.endsWith("/")) {
            search = search.substring(1, search.length() - 1);
            matcher = (s1, s2) -> Pattern.compile(s2).matcher((CharSequence)s1).find();
        }
        if (stack.func_77948_v()) {
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
            for (Enchantment enchantment : enchants.keySet()) {
                if (enchantment == null || !matcher.test(enchantment.func_200305_d(((Integer)enchants.get(enchantment)).intValue()).toString().toLowerCase(Locale.ROOT), search)) continue;
                return true;
            }
        }
        ArrayList potionNames = new ArrayList();
        PotionUtils.func_185182_a((ItemStack)stack, potionNames, (float)1.0f);
        for (ITextComponent iTextComponent : potionNames) {
            if (!matcher.test(TextFormatting.func_110646_a((String)iTextComponent.toString().trim().toLowerCase(Locale.ROOT)), search)) continue;
            return true;
        }
        for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet()) {
            int lvl = (Integer)entry.getValue();
            Enchantment e = (Enchantment)entry.getKey();
            if (e == null || !matcher.test(e.func_200305_d(lvl).toString().toLowerCase(Locale.ROOT), search)) continue;
            return true;
        }
        ItemGroup tab = item.func_77640_w();
        if (tab != null && matcher.test(tab.func_242392_c().getString().toLowerCase(Locale.ROOT), search)) {
            return true;
        }
        ResourceLocation resourceLocation = item.getRegistryName();
        Optional mod = ModList.get().getModContainerById(resourceLocation.func_110623_a());
        if (mod.isPresent() && matcher.test(((ModContainer)mod.orElse(null)).getModInfo().getDisplayName().toLowerCase(Locale.ROOT), search)) {
            return true;
        }
        return matcher.test(name, search);
    }

    static {
        text = "";
        searchEnabled = false;
    }

    private static interface StringMatcher
    extends BiPredicate<String, String> {
    }
}

