/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.mobs.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import vazkii.quark.mobs.entity.FrogEntity;

public class FrogModel
extends EntityModel<FrogEntity> {
    private float frogSize;
    public final ModelRenderer headTop;
    public final ModelRenderer headBottom;
    public final ModelRenderer body;
    public final ModelRenderer rightArm;
    public final ModelRenderer leftArm;
    public final ModelRenderer rightEye;
    public final ModelRenderer leftEye;

    public FrogModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.rightArm = new ModelRenderer((Model)this, 33, 7);
        this.rightArm.field_78809_i = true;
        this.rightArm.func_78793_a(6.5f, 22.0f, 1.0f);
        this.rightArm.func_228301_a_(-1.0f, -1.0f, -5.0f, 3.0f, 3.0f, 6.0f, 0.0f);
        this.leftArm = new ModelRenderer((Model)this, 33, 7);
        this.leftArm.func_78793_a(-6.5f, 22.0f, 1.0f);
        this.leftArm.func_228301_a_(-2.0f, -1.0f, -5.0f, 3.0f, 3.0f, 6.0f, 0.0f);
        this.body = new ModelRenderer((Model)this, 0, 7);
        this.body.func_78793_a(0.0f, 20.0f, 0.0f);
        this.body.func_228301_a_(-5.5f, -3.0f, 0.0f, 11.0f, 7.0f, 11.0f, 0.0f);
        this.headTop = new ModelRenderer((Model)this, 0, 0);
        this.headTop.func_78793_a(0.0f, 18.0f, 0.0f);
        this.headTop.func_228301_a_(-5.5f, -1.0f, -5.0f, 11.0f, 2.0f, 5.0f, 0.0f);
        this.headBottom = new ModelRenderer((Model)this, 32, 0);
        this.headBottom.func_78793_a(0.0f, 18.0f, 0.0f);
        this.headBottom.func_228301_a_(-5.5f, 1.0f, -5.0f, 11.0f, 2.0f, 5.0f, 0.0f);
        this.rightEye = new ModelRenderer((Model)this, 0, 0);
        this.rightEye.field_78809_i = true;
        this.rightEye.func_78793_a(0.0f, 18.0f, 0.0f);
        this.rightEye.func_228301_a_(1.5f, -1.5f, -4.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        this.leftEye = new ModelRenderer((Model)this, 0, 0);
        this.leftEye.func_78793_a(0.0f, 18.0f, 0.0f);
        this.leftEye.func_228301_a_(-2.5f, -1.5f, -4.0f, 1.0f, 1.0f, 1.0f, 0.0f);
    }

    public void setLivingAnimations(FrogEntity frog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        int rawTalkTime = frog.getTalkTime();
        this.headBottom.field_78795_f = 0.02617994f;
        if (rawTalkTime != 0) {
            float talkTime = (float)rawTalkTime - partialTickTime;
            int speed = 10;
            this.headBottom.field_78795_f = (float)((double)this.headBottom.field_78795_f + 0.39269908169872414 * (double)(1.0f - MathHelper.func_76134_b((float)(talkTime * (float)Math.PI * 2.0f / (float)speed))));
        }
    }

    public void setRotationAngles(FrogEntity frog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.frogSize = frog.getSizeModifier();
        this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 2.0f / 3.0f)) * 1.0f * limbSwingAmount;
        this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 2.0f / 3.0f)) * 1.0f * limbSwingAmount;
        this.rightEye.field_78795_f = this.leftEye.field_78795_f = (this.headTop.field_78795_f = headPitch * (float)Math.PI / 180.0f);
        this.headBottom.field_78795_f += headPitch * (float)Math.PI / 180.0f;
        if (frog.isVoid()) {
            this.headTop.field_78795_f *= -1.0f;
            this.rightEye.field_78795_f *= -1.0f;
            this.leftEye.field_78795_f *= -1.0f;
            this.headBottom.field_78795_f *= -1.0f;
        }
    }

    public void func_225598_a_(MatrixStack matrix, @Nonnull IVertexBuilder vb, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 1.5 - (double)this.frogSize * 1.5, 0.0);
        matrix.func_227862_a_(this.frogSize, this.frogSize, this.frogSize);
        if (this.field_217114_e) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 0.6, 0.0);
            matrix.func_227862_a_(0.625f, 0.625f, 0.625f);
        }
        this.headTop.func_228309_a_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.headBottom.func_228309_a_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.rightEye.func_228309_a_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leftEye.func_228309_a_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (this.field_217114_e) {
            matrix.func_227865_b_();
            matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrix.func_227861_a_(0.0, 1.5, 0.0);
        }
        this.rightArm.func_228309_a_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leftArm.func_228309_a_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.body.func_228309_a_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrix.func_227865_b_();
    }
}

