/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.mobs.client.render;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import vazkii.quark.mobs.client.layer.FoxhoundCollarLayer;
import vazkii.quark.mobs.client.model.FoxhoundModel;
import vazkii.quark.mobs.entity.FoxhoundEntity;

public class FoxhoundRenderer
extends MobRenderer<FoxhoundEntity, FoxhoundModel> {
    private static final ResourceLocation FOXHOUND_IDLE = new ResourceLocation("quark", "textures/model/entity/foxhound/red/idle.png");
    private static final ResourceLocation FOXHOUND_HOSTILE = new ResourceLocation("quark", "textures/model/entity/foxhound/red/hostile.png");
    private static final ResourceLocation FOXHOUND_SLEEPING = new ResourceLocation("quark", "textures/model/entity/foxhound/red/sleeping.png");
    private static final ResourceLocation SOULHOUND_IDLE = new ResourceLocation("quark", "textures/model/entity/foxhound/blue/idle.png");
    private static final ResourceLocation SOULHOUND_HOSTILE = new ResourceLocation("quark", "textures/model/entity/foxhound/blue/hostile.png");
    private static final ResourceLocation SOULHOUND_SLEEPING = new ResourceLocation("quark", "textures/model/entity/foxhound/blue/sleeping.png");
    private static final ResourceLocation BASALT_FOXHOUND_IDLE = new ResourceLocation("quark", "textures/model/entity/foxhound/black/idle.png");
    private static final ResourceLocation BASALT_FOXHOUND_HOSTILE = new ResourceLocation("quark", "textures/model/entity/foxhound/black/hostile.png");
    private static final ResourceLocation BASALT_FOXHOUND_SLEEPING = new ResourceLocation("quark", "textures/model/entity/foxhound/black/sleeping.png");
    private static final int SHINY_CHANCE = 256;

    public FoxhoundRenderer(EntityRendererManager render) {
        super(render, (EntityModel)new FoxhoundModel(), 0.5f);
        this.func_177094_a(new FoxhoundCollarLayer((IEntityRenderer<FoxhoundEntity, FoxhoundModel>)this));
    }

    @Nullable
    public ResourceLocation getEntityTexture(@Nonnull FoxhoundEntity entity) {
        if (entity.isBlue()) {
            return entity.func_233684_eK_() ? SOULHOUND_SLEEPING : (entity.func_230256_F__() > 0 ? SOULHOUND_HOSTILE : SOULHOUND_IDLE);
        }
        UUID id = entity.func_110124_au();
        long most = id.getMostSignificantBits();
        if (most % 256L == 0L) {
            return entity.func_233684_eK_() ? BASALT_FOXHOUND_SLEEPING : (entity.func_230256_F__() > 0 ? BASALT_FOXHOUND_HOSTILE : BASALT_FOXHOUND_IDLE);
        }
        return entity.func_233684_eK_() ? FOXHOUND_SLEEPING : (entity.func_230256_F__() > 0 ? FOXHOUND_HOSTILE : FOXHOUND_IDLE);
    }
}

