/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.mobs.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.quark.mobs.client.model.FrogModel;
import vazkii.quark.mobs.entity.FrogEntity;

public class FrogRenderer
extends MobRenderer<FrogEntity, FrogModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("quark", "textures/model/entity/frog.png");
    private static final ResourceLocation TEXTURE_SWEATER = new ResourceLocation("quark", "textures/model/entity/events/sweater_frog.png");
    private static final ResourceLocation TEXTURE_FUNNY = new ResourceLocation("quark", "textures/model/entity/events/funny_rat_frog.png");
    private static final ResourceLocation TEXTURE_SWEATER_FUNNY = new ResourceLocation("quark", "textures/model/entity/events/sweater_funny_rat_frog.png");
    private static final ResourceLocation TEXTURE_SNAKE = new ResourceLocation("quark", "textures/model/entity/events/snake_block_frog.png");
    private static final ResourceLocation TEXTURE_SWEATER_SNAKE = new ResourceLocation("quark", "textures/model/entity/events/sweater_snake_block_frog.png");
    private static final ResourceLocation TEXTURE_KERMIT = new ResourceLocation("quark", "textures/model/entity/events/kermit_frog.png");
    private static final ResourceLocation TEXTURE_SWEATER_KERMIT = new ResourceLocation("quark", "textures/model/entity/events/sweater_kermit_frog.png");
    private static final ResourceLocation TEXTURE_VOID = new ResourceLocation("quark", "textures/model/entity/events/void_frog.png");
    private static final ResourceLocation TEXTURE_SWEATER_VOID = new ResourceLocation("quark", "textures/model/entity/events/sweater_void_frog.png");

    public FrogRenderer(EntityRendererManager manager) {
        super(manager, (EntityModel)new FrogModel(), 0.2f);
    }

    protected void applyRotations(@Nonnull FrogEntity frog, @Nonnull MatrixStack matrix, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)frog, matrix, ageInTicks, rotationYaw, partialTicks);
        if (frog.isVoid()) {
            matrix.func_227861_a_(0.0, (double)frog.func_213302_cg(), 0.0);
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        }
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull FrogEntity entity) {
        if (entity.isVoid()) {
            return entity.hasSweater() ? TEXTURE_SWEATER_VOID : TEXTURE_VOID;
        }
        if (entity.func_145818_k_()) {
            String name = entity.func_200201_e().getString().trim();
            if (name.equalsIgnoreCase("Alex") || name.equalsIgnoreCase("Rat") || name.equalsIgnoreCase("Funny Rat")) {
                return entity.hasSweater() ? TEXTURE_SWEATER_FUNNY : TEXTURE_FUNNY;
            }
            if (name.equalsIgnoreCase("Snake") || name.equalsIgnoreCase("SnakeBlock") || name.equalsIgnoreCase("Snake Block")) {
                return entity.hasSweater() ? TEXTURE_SWEATER_SNAKE : TEXTURE_SNAKE;
            }
            if (name.equalsIgnoreCase("Kermit")) {
                return entity.hasSweater() ? TEXTURE_SWEATER_KERMIT : TEXTURE_KERMIT;
            }
        }
        return entity.hasSweater() ? TEXTURE_SWEATER : TEXTURE;
    }
}

