/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.mobs.entity;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BegGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.quark.mobs.ai.FindPlaceToSleepGoal;
import vazkii.quark.mobs.ai.SleepGoal;
import vazkii.quark.mobs.module.FoxhoundModule;
import vazkii.quark.tweaks.ai.WantLoveGoal;

public class FoxhoundEntity
extends WolfEntity
implements IMob {
    public static final ResourceLocation FOXHOUND_LOOT_TABLE = new ResourceLocation("quark", "entities/foxhound");
    private static final DataParameter<Boolean> TEMPTATION = EntityDataManager.func_187226_a(FoxhoundEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(FoxhoundEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_BLUE = EntityDataManager.func_187226_a(FoxhoundEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int timeUntilPotatoEmerges = 0;
    protected SleepGoal sleepGoal;

    public FoxhoundEntity(EntityType<? extends FoxhoundEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_175547_a(DyeColor.ORANGE);
        this.field_70180_af.func_187214_a(TEMPTATION, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(IS_BLUE, (Object)false);
    }

    public int func_70641_bl() {
        return 4;
    }

    public boolean func_104002_bU() {
        return super.func_104002_bU();
    }

    public boolean func_213392_I() {
        return this.func_70909_n();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70909_n();
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        Biome biome = worldIn.func_226691_t_(new BlockPos(this.func_213303_ch()));
        ResourceLocation res = worldIn.func_201672_e().func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
        if (res.equals((Object)Biomes.field_235252_ay_.func_240901_a_())) {
            this.setBlue(true);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70071_h_() {
        BlockPos below;
        TileEntity tile;
        LivingEntity owner;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && !this.func_70909_n()) {
            this.func_70106_y();
            return;
        }
        if (!(!WantLoveGoal.needsPets((TameableEntity)this) || (owner = this.func_70902_q()) == null || !(owner.func_70068_e((Entity)this) < 1.0) || owner.func_70090_H() || owner.func_230279_az_() || owner instanceof PlayerEntity && ((PlayerEntity)owner).func_184812_l_())) {
            owner.func_70015_d(5);
        }
        Vector3d pos = this.func_213303_ch();
        if (this.field_70170_p.field_72995_K) {
            BasicParticleType particle = ParticleTypes.field_197631_x;
            if (this.func_233684_eK_()) {
                particle = ParticleTypes.field_197601_L;
            } else if (this.isBlue()) {
                particle = ParticleTypes.field_239811_B_;
            }
            this.field_70170_p.func_195594_a((IParticleData)particle, pos.field_72450_a + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), pos.field_72448_b + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213302_cg(), pos.field_72449_c + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
        }
        if (this.func_70909_n() && (tile = this.field_70170_p.func_175625_s(below = this.func_233580_cy_().func_177977_b())) instanceof AbstractFurnaceTileEntity) {
            List foxhounds;
            AbstractFurnaceTileEntity furnace = (AbstractFurnaceTileEntity)tile;
            int cookTime = furnace.field_214020_l;
            if (cookTime > 0 && cookTime % 3 == 0 && !(foxhounds = this.field_70170_p.func_175647_a(FoxhoundEntity.class, new AxisAlignedBB(this.func_233580_cy_()), fox -> fox != null && fox.func_70909_n())).isEmpty() && foxhounds.get(0) == this) {
                furnace.field_214020_l = furnace.field_214020_l == 3 ? 5 : Math.min(furnace.field_214021_m - 1, cookTime + 1);
            }
        }
    }

    public boolean func_70026_G() {
        return false;
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        return FOXHOUND_LOOT_TABLE;
    }

    protected void func_184651_r() {
        this.sleepGoal = new SleepGoal(this);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)this.sleepGoal);
        this.field_70714_bg.func_75776_a(3, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new FindPlaceToSleepGoal(this, 0.8, true));
        this.field_70714_bg.func_75776_a(9, (Goal)new FindPlaceToSleepGoal(this, 0.8, false));
        this.field_70714_bg.func_75776_a(10, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(11, (Goal)new BegGoal((WolfEntity)this, 8.0f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, AnimalEntity.class, false, target -> target instanceof SheepEntity || target instanceof RabbitEntity));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, PlayerEntity.class, false, target -> !this.func_70909_n()));
    }

    public int func_230256_F__() {
        if (!this.func_70909_n() && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
            return 0;
        }
        return super.func_230256_F__();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn.func_200600_R().func_220338_c()) {
            if (entityIn instanceof PlayerEntity) {
                return false;
            }
            return super.func_70652_k(entityIn);
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_76361_j(), (float)((int)this.func_233637_b_(Attributes.field_233823_f_)));
        if (flag) {
            entityIn.func_70015_d(5);
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        this.setWoke();
        return super.func_70097_a(source, amount);
    }

    @Nonnull
    public ActionResultType func_230254_b_(PlayerEntity player, @Nonnull Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151103_aS && !this.func_70909_n()) {
            return ActionResultType.PASS;
        }
        if (!(this.func_70909_n() || itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151044_h || this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && !player.func_184812_l_() && player.func_70660_b(Effects.field_76426_n) == null || this.field_70170_p.field_72995_K)) {
            if (this.field_70146_Z.nextDouble() < FoxhoundModule.tameChance) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.func_70606_j(20.0f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setWoke();
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return super.func_70878_b(otherAnimal) && otherAnimal instanceof FoxhoundEntity;
    }

    public WolfEntity func_241840_a(ServerWorld sworld, AgeableEntity otherParent) {
        FoxhoundEntity kid = new FoxhoundEntity(FoxhoundModule.foxhoundType, this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            kid.func_184754_b(uuid);
            kid.func_70903_f(true);
        }
        if (this.isBlue()) {
            kid.setBlue(true);
        }
        return kid;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("OhLawdHeComin", this.timeUntilPotatoEmerges);
        compound.func_74757_a("IsSlep", this.func_233684_eK_());
        compound.func_74757_a("IsBlue", this.isBlue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.timeUntilPotatoEmerges = compound.func_74762_e("OhLawdHeComin");
        this.func_233686_v_(compound.func_74767_n("IsSlep"));
        this.setBlue(compound.func_74767_n("IsBlue"));
    }

    protected SoundEvent func_184639_G() {
        return this.func_233684_eK_() ? null : super.func_184639_G();
    }

    public boolean func_233684_eK_() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    public boolean isBlue() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BLUE);
    }

    public void func_233686_v_(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
    }

    public void setBlue(boolean blue) {
        this.field_70180_af.func_187227_b(IS_BLUE, (Object)blue);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(FoxhoundModule.foxhoundSpawnableTag) ? 10.0f : worldIn.func_205052_D(pos) - 0.5f;
    }

    public static boolean spawnPredicate(EntityType<? extends FoxhoundEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && world.func_180495_p(pos.func_177977_b()).func_235714_a_(FoxhoundModule.foxhoundSpawnableTag);
    }

    public SleepGoal getSleepGoal() {
        return this.sleepGoal;
    }

    private void setWoke() {
        SleepGoal sleep = this.getSleepGoal();
        if (sleep != null) {
            this.func_233686_v_(false);
            sleep.setSleeping(false);
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

