/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.block;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.Module;
import vazkii.quark.oddities.tile.MagnetizedBlockTileEntity;

public class MovingMagnetizedBlock
extends QuarkBlock {
    public static final DirectionProperty FACING = PistonHeadBlock.field_176387_N;

    public MovingMagnetizedBlock(Module module) {
        super("magnetized_block", module, null, AbstractBlock.Properties.func_200945_a((Material)Material.field_76233_E).func_200943_b(-1.0f).func_208770_d().func_222380_e().func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return null;
    }

    public void func_196243_a(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        MagnetizedBlockTileEntity tile;
        if (state.func_177230_c() != newState.func_177230_c() && (tile = this.getMagnetTileEntity((IBlockReader)worldIn, pos)) != null) {
            tile.clearMagnetTileEntity();
        }
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) == null) {
            worldIn.func_217377_a(pos, false);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public List<ItemStack> func_220076_a(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        MagnetizedBlockTileEntity tile = this.getMagnetTileEntity((IBlockReader)builder.func_216018_a(), (Vector3d)builder.func_216024_a(LootParameters.field_237457_g_));
        return tile == null ? Collections.emptyList() : tile.getMagnetState().func_215693_a(builder);
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, ISelectionContext context) {
        MagnetizedBlockTileEntity tile = this.getMagnetTileEntity(worldIn, pos);
        return tile != null ? tile.getCollisionShape(worldIn, pos) : VoxelShapes.func_197880_a();
    }

    @Nullable
    private MagnetizedBlockTileEntity getMagnetTileEntity(IBlockReader world, Vector3d origin) {
        BlockPos pos = new BlockPos(origin);
        return this.getMagnetTileEntity(world, pos);
    }

    @Nullable
    private MagnetizedBlockTileEntity getMagnetTileEntity(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof MagnetizedBlockTileEntity ? (MagnetizedBlockTileEntity)tile : null;
    }

    @Nonnull
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public BlockState func_185499_a(@Nonnull BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(@Nonnull BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, PathType type) {
        return false;
    }
}

