/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.item;

import com.mojang.datafixers.util.Pair;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.Module;
import vazkii.quark.oddities.module.TotemOfHoldingModule;

public class SoulCompassItem
extends QuarkItem {
    private static final String TAG_POS_X = "posX";
    private static final String TAG_DIMENSION_ID = "dimensionID";
    private static final String TAG_POS_Z = "posZ";
    @OnlyIn(value=Dist.CLIENT)
    private static double rotation;
    @OnlyIn(value=Dist.CLIENT)
    private static double rota;
    @OnlyIn(value=Dist.CLIENT)
    private static long lastUpdateTick;

    public SoulCompassItem(Module module) {
        super("soul_compass", module, new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float angle(ItemStack stack, ClientWorld world, LivingEntity entityIn) {
        double angle;
        LivingEntity entity;
        if (entityIn == null && !stack.func_82839_y()) {
            return 0.0f;
        }
        boolean hasEntity = entityIn != null;
        Object object = entity = hasEntity ? entityIn : stack.func_82836_z();
        if (entity == null) {
            return 0.0f;
        }
        if (world == null && entity != null && entity.field_70170_p instanceof ClientWorld) {
            world = (ClientWorld)entity.field_70170_p;
        }
        BlockPos pos = SoulCompassItem.getPos(stack);
        if (SoulCompassItem.getDim(stack).equals(world.func_234923_W_().func_240901_a_().toString())) {
            double yaw = hasEntity ? (double)entity.field_70177_z : SoulCompassItem.getFrameRotation((ItemFrameEntity)entity);
            yaw = MathHelper.func_191273_b((double)(yaw / 360.0), (double)1.0);
            double relAngle = SoulCompassItem.getDeathToAngle((Entity)entity, pos) / (Math.PI * 2);
            angle = 0.5 - (yaw - 0.25 - relAngle);
        } else {
            angle = Math.random();
        }
        if (hasEntity) {
            angle = SoulCompassItem.wobble((World)world, angle);
        }
        return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Pair<BlockPos, String> deathPos;
        if (!worldIn.field_72995_K && (deathPos = TotemOfHoldingModule.getPlayerDeathPosition(entityIn)) != null) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_X, (int)((BlockPos)deathPos.getFirst()).func_177958_n());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Z, (int)((BlockPos)deathPos.getFirst()).func_177952_p());
            ItemNBTHelper.setString((ItemStack)stack, (String)TAG_DIMENSION_ID, (String)((String)deathPos.getSecond()));
        }
    }

    private static BlockPos getPos(ItemStack stack) {
        if (stack.func_77942_o()) {
            int x = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_X, (int)0);
            int y = -1;
            int z = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Z, (int)0);
            return new BlockPos(x, y, z);
        }
        return new BlockPos(0, -1, 0);
    }

    private static String getDim(ItemStack stack) {
        if (stack.func_77942_o()) {
            return ItemNBTHelper.getString((ItemStack)stack, (String)TAG_DIMENSION_ID, (String)"");
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    private static double wobble(World worldIn, double angle) {
        if (worldIn.func_82737_E() != lastUpdateTick) {
            lastUpdateTick = worldIn.func_82737_E();
            double relAngle = angle - rotation;
            relAngle = MathHelper.func_191273_b((double)(relAngle + 0.5), (double)1.0) - 0.5;
            rota += relAngle * 0.1;
            rotation = MathHelper.func_191273_b((double)(rotation + (rota *= 0.8)), (double)1.0);
        }
        return rotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static double getFrameRotation(ItemFrameEntity frame) {
        Direction facing = frame.func_174811_aO();
        return MathHelper.func_76142_g((float)(180.0f + facing.func_185119_l()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static double getDeathToAngle(Entity entity, BlockPos blockpos) {
        return Math.atan2((double)blockpos.func_177952_p() - entity.func_226281_cx_(), (double)blockpos.func_177958_n() - entity.func_226277_ct_());
    }
}

