/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.module;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.OverrideRegistryHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.oddities.block.MatrixEnchantingTableBlock;
import vazkii.quark.oddities.client.render.MatrixEnchantingTableTileEntityRenderer;
import vazkii.quark.oddities.client.screen.MatrixEnchantingScreen;
import vazkii.quark.oddities.container.MatrixEnchantingContainer;
import vazkii.quark.oddities.tile.MatrixEnchantingTableTileEntity;

@LoadModule(category=ModuleCategory.ODDITIES, requiredMod="quarkoddities", hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class MatrixEnchantingModule
extends Module {
    public static TileEntityType<MatrixEnchantingTableTileEntity> tileEntityType;
    public static ContainerType<MatrixEnchantingContainer> containerType;
    @Config(description="The maximum enchanting power the matrix enchanter can accept")
    public static int maxBookshelves;
    @Config(description="Should this be X, the price of a piece increase by 1 every X pieces you generate")
    public static int piecePriceScale;
    @Config(description="The higher this is, the better enchantments you'll get on books")
    public static int bookEnchantability;
    @Config(description="How many pieces you can generate without any bookshelves")
    public static int baseMaxPieceCount;
    @Config(description="How many pieces you can generate without any bookshelves (for Books)")
    public static int baseMaxPieceCountBook;
    @Config(description="At which piece count the calculation for the min level should default to increasing one per piece rather than using the scale factor")
    public static int minLevelCutoff;
    @Config(description="How many pieces a single Lapis can generate")
    public static int chargePerLapis;
    @Config(description="How much the min level requirement for adding a new piece should increase for each piece added (up until the value of Min Level Cutoff)")
    public static double minLevelScaleFactor;
    @Config(description="How much the min level requirement for adding a new piece to a book should increase per each bookshelf being used")
    public static double minLevelScaleFactorBook;
    @Config(description="How much to multiply the frequency of pieces where at least one of the same type has been generated")
    public static double dupeMultiplier;
    @Config(description="How much to multiply the frequency of pieces where incompatible pieces have been generated")
    public static double incompatibleMultiplier;
    @Config(description="Set to false to disable the ability to create Enchanted Books")
    public static boolean allowBooks;
    @Config(description="Set this to true to allow treasure enchantments to be rolled as pieces")
    public static boolean allowTreasures;
    @Config(description="Set to false to disable the tooltip for items with pending enchantments")
    public static boolean showTooltip;
    @Config(description="By default, enchantment rarities are fuzzed a bit to feel better with the new system. Set this to false to override this behaviour.")
    public static boolean normalizeRarity;
    @Config(description="Matrix Enchanting can be done with water instead of air around the enchanting table. Set this to false to disable this behaviour.")
    public static boolean allowUnderwaterEnchanting;
    @Config(description="A list of enchantment IDs you don't want the enchantment table to be able to create")
    public static List<String> disallowedEnchantments;
    @Config(description="An array of influences each candle should apply. This list must be 16 elements long, and is in order of wool colors.")
    private static List<String> influencesList;
    @Config(description="Set to false to disable the ability to influence enchantment outcomes with candles (requires the Tallow and Candles module enabled)")
    public static boolean allowInfluencing;
    @Config(description="The max amount of candles that can influence a single enchantment")
    public static int influenceMax;
    @Config(description="How much each candle influences an enchantment. This works as a multiplier to its weight")
    public static double influencePower;
    public static Map<DyeColor, List<Enchantment>> candleInfluences;

    @Override
    public void construct() {
        MatrixEnchantingTableBlock matrixEnchanter = new MatrixEnchantingTableBlock();
        OverrideRegistryHandler.registerBlock((Block)matrixEnchanter, "enchanting_table", ItemGroup.field_78031_c);
        containerType = IForgeContainerType.create(MatrixEnchantingContainer::fromNetwork);
        RegistryHelper.register(containerType, (String)"matrix_enchanting");
        tileEntityType = TileEntityType.Builder.func_223042_a(MatrixEnchantingTableTileEntity::new, (Block[])new Block[]{matrixEnchanter}).func_206865_a(null);
        RegistryHelper.register(tileEntityType, (String)"matrix_enchanting");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        ScreenManager.func_216911_a(containerType, MatrixEnchantingScreen::new);
        ClientRegistry.bindTileEntityRenderer(tileEntityType, MatrixEnchantingTableTileEntityRenderer::new);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (showTooltip && ItemNBTHelper.verifyExistence((ItemStack)stack, (String)"quark:enchantingMatrix")) {
            event.getToolTip().add(new TranslationTextComponent("quark.gui.enchanting.pending").func_240699_a_(TextFormatting.AQUA));
        }
    }

    @Override
    public void configChanged() {
        this.parseInfluences();
    }

    private void parseInfluences() {
        candleInfluences = new HashMap<DyeColor, List<Enchantment>>();
        if (influencesList.size() != 16) {
            new IllegalArgumentException("Matrix Enchanting Influences must be of size 16, please fix this in the config.").printStackTrace();
            allowInfluencing = false;
            return;
        }
        for (int i = 0; i < 16; ++i) {
            String[] tokens;
            LinkedList list = new LinkedList();
            candleInfluences.put(DyeColor.values()[i], list);
            String s = influencesList.get(i);
            for (String enchStr : tokens = s.split(",")) {
                Optional ench = Registry.field_212628_q.func_241873_b(new ResourceLocation(enchStr = enchStr.trim()));
                if (ench.isPresent()) {
                    list.add(ench.get());
                    continue;
                }
                Quark.LOG.error("Matrix Enchanting Influencing: Enchantment " + enchStr + " does not exist!");
            }
        }
    }

    static {
        maxBookshelves = 15;
        piecePriceScale = 9;
        bookEnchantability = 12;
        baseMaxPieceCount = 3;
        baseMaxPieceCountBook = 1;
        minLevelCutoff = 10;
        chargePerLapis = 4;
        minLevelScaleFactor = 1.5;
        minLevelScaleFactorBook = 2.0;
        dupeMultiplier = 1.4;
        incompatibleMultiplier = 0.0;
        allowBooks = true;
        allowTreasures = false;
        showTooltip = true;
        normalizeRarity = true;
        allowUnderwaterEnchanting = true;
        disallowedEnchantments = Lists.newArrayList();
        influencesList = Lists.newArrayList((Object[])new String[]{"minecraft:unbreaking", "minecraft:fire_protection", "minecraft:knockback,minecraft:punch", "minecraft:feather_falling", "minecraft:looting,minecraft:fortune,minecraft:luck_of_the_sea", "minecraft:blast_protection", "minecraft:silk_touch,minecraft:channeling", "minecraft:bane_of_arthropods", "minecraft:protection", "minecraft:respiration,minecraft:loyalty,minecraft:infinity", "minecraft:sweeping,minecraft:multishot", "minecraft:efficiency,minecraft:sharpness,minecraft:lure,minecraft:power,minecraft:impaling,minecraft:quick_charge", "minecraft:aqua_affinity,minecraft:depth_strider,minecraft:riptide", "minecraft:thorns,minecraft:piercing", "minecraft:fire_aspect,minecraft:flame", "minecraft:smite,minecraft:projectile_protection"});
        allowInfluencing = true;
        influenceMax = 4;
        influencePower = 0.125;
    }
}

