/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.tile;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import vazkii.quark.oddities.block.MagnetBlock;
import vazkii.quark.oddities.magnetsystem.MagnetSystem;
import vazkii.quark.oddities.module.MagnetsModule;

public class MagnetTileEntity
extends TileEntity
implements ITickableTileEntity {
    public MagnetTileEntity() {
        super(MagnetsModule.magnetType);
    }

    public void func_73660_a() {
        BlockState state = this.func_195044_w();
        boolean powered = (Boolean)state.func_177229_b((Property)MagnetBlock.POWERED);
        if (powered) {
            Direction dir = (Direction)state.func_177229_b((Property)MagnetBlock.FACING);
            int power = this.getPower(dir);
            this.magnetize(dir, dir, power);
            this.magnetize(dir.func_176734_d(), dir, power);
        }
    }

    private void magnetize(Direction dir, Direction moveDir, int power) {
        BlockPos targetPos;
        BlockState targetState;
        if (this.field_145850_b == null) {
            return;
        }
        double magnitude = dir == moveDir ? 1 : -1;
        double particleMotion = 0.05 * magnitude;
        double particleChance = 0.2;
        double xOff = (double)dir.func_82601_c() * particleMotion;
        double yOff = (double)dir.func_96559_d() * particleMotion;
        double zOff = (double)dir.func_82599_e() * particleMotion;
        for (int i = 1; i <= power && (targetState = this.field_145850_b.func_180495_p(targetPos = this.field_174879_c.func_177967_a(dir, i))).func_177230_c() != MagnetsModule.magnetized_block; ++i) {
            BlockPos frontPos;
            BlockState frontState;
            PushReaction reaction;
            if (!this.field_145850_b.field_72995_K && targetState.func_177230_c() != Blocks.field_196603_bb && targetState.func_177230_c() != MagnetsModule.magnetized_block && ((reaction = MagnetSystem.getPushAction(this, targetPos, targetState, moveDir)) == PushReaction.IGNORE || reaction == PushReaction.DESTROY) && (frontState = this.field_145850_b.func_180495_p(frontPos = targetPos.func_177972_a(moveDir))).isAir((IBlockReader)this.field_145850_b, frontPos)) {
                MagnetSystem.applyForce(this.field_145850_b, targetPos, power - i + 1, dir == moveDir, moveDir, i, this.field_174879_c);
            }
            if (!targetState.isAir((IBlockReader)this.field_145850_b, targetPos)) break;
            if (!this.field_145850_b.field_72995_K || !(Math.random() <= particleChance)) continue;
            double x = (double)targetPos.func_177958_n() + (xOff == 0.0 ? 0.5 : Math.random());
            double y = (double)targetPos.func_177956_o() + (yOff == 0.0 ? 0.5 : Math.random());
            double z = (double)targetPos.func_177952_p() + (zOff == 0.0 ? 0.5 : Math.random());
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_218421_R, x, y, z, xOff, yOff, zOff);
        }
    }

    private int getPower(Direction curr) {
        if (this.field_145850_b == null) {
            return 0;
        }
        int power = 0;
        Direction opp = curr.func_176734_d();
        for (Direction dir : Direction.values()) {
            if (dir == opp || dir == curr) continue;
            int offPower = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir);
            power = Math.max(offPower, power);
        }
        return power;
    }
}

