/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.tile;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.api.IMagnetMoveAction;
import vazkii.quark.oddities.magnetsystem.MagnetSystem;
import vazkii.quark.oddities.module.MagnetsModule;

public class MagnetizedBlockTileEntity
extends TileEntity
implements ITickableTileEntity {
    private BlockState magnetState;
    private CompoundNBT subTile;
    private Direction magnetFacing;
    private static final ThreadLocal<Direction> MOVING_ENTITY = ThreadLocal.withInitial(() -> null);
    private float progress;
    private float lastProgress;
    private long lastTicked;

    public MagnetizedBlockTileEntity() {
        super(MagnetsModule.magnetizedBlockType);
    }

    public MagnetizedBlockTileEntity(BlockState magnetStateIn, CompoundNBT subTileIn, Direction magnetFacingIn) {
        this();
        this.magnetState = magnetStateIn;
        this.subTile = subTileIn;
        this.magnetFacing = magnetFacingIn;
    }

    public Direction getFacing() {
        return this.magnetFacing;
    }

    public float getProgress(float ticks) {
        if (ticks > 1.0f) {
            ticks = 1.0f;
        }
        return MathHelper.func_219799_g((float)ticks, (float)this.lastProgress, (float)this.progress);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getOffsetX(float ticks) {
        return (float)this.magnetFacing.func_82601_c() * this.getExtendedProgress(this.getProgress(ticks));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getOffsetY(float ticks) {
        return (float)this.magnetFacing.func_96559_d() * this.getExtendedProgress(this.getProgress(ticks));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getOffsetZ(float ticks) {
        return (float)this.magnetFacing.func_82599_e() * this.getExtendedProgress(this.getProgress(ticks));
    }

    private float getExtendedProgress(float partialTicks) {
        return partialTicks - 1.0f;
    }

    private void moveCollidedEntities(float progress) {
        List boundingBoxes;
        AxisAlignedBB containingBox;
        List entities;
        if (this.field_145850_b == null) {
            return;
        }
        Direction direction = this.magnetFacing;
        double movement = progress - this.progress;
        VoxelShape collision = this.magnetState.func_196952_d((IBlockReader)this.field_145850_b, this.func_174877_v());
        if (!collision.func_197766_b() && !(entities = this.field_145850_b.func_72839_b(null, this.getMovementArea(containingBox = this.moveByPositionAndProgress(this.getEnclosingBox(boundingBoxes = collision.func_197756_d())), direction, movement).func_111270_a(containingBox))).isEmpty()) {
            boolean sticky = this.magnetState.func_177230_c().isStickyBlock(this.magnetState);
            for (Entity entity : entities) {
                AxisAlignedBB entityBox;
                AxisAlignedBB aList;
                AxisAlignedBB movementArea;
                if (entity.func_184192_z() == PushReaction.IGNORE) continue;
                if (sticky) {
                    Vector3d motion = entity.func_213322_ci();
                    double dX = motion.field_72450_a;
                    double dY = motion.field_72448_b;
                    double dZ = motion.field_72449_c;
                    switch (direction.func_176740_k()) {
                        case X: {
                            dX = direction.func_82601_c();
                            break;
                        }
                        case Y: {
                            dY = direction.func_96559_d();
                            break;
                        }
                        case Z: {
                            dZ = direction.func_82599_e();
                        }
                    }
                    entity.func_213293_j(dX, dY, dZ);
                }
                double motion = 0.0;
                Iterator iterator = boundingBoxes.iterator();
                while (!(!iterator.hasNext() || (movementArea = this.getMovementArea(this.moveByPositionAndProgress(aList = (AxisAlignedBB)iterator.next()), direction, movement)).func_72326_a(entityBox = entity.func_174813_aQ()) && (motion = Math.max(motion, this.getMovement(movementArea, direction, entityBox))) >= movement)) {
                }
                if (!(motion > 0.0)) continue;
                motion = Math.min(motion, movement) + 0.01;
                MOVING_ENTITY.set(direction);
                entity.func_213315_a(MoverType.PISTON, new Vector3d(motion * (double)direction.func_82601_c(), motion * (double)direction.func_96559_d(), motion * (double)direction.func_82599_e()));
                MOVING_ENTITY.set(null);
            }
        }
    }

    private AxisAlignedBB getEnclosingBox(List<AxisAlignedBB> boxes) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        for (AxisAlignedBB bb : boxes) {
            minX = Math.min(bb.field_72340_a, minX);
            minY = Math.min(bb.field_72338_b, minY);
            minZ = Math.min(bb.field_72339_c, minZ);
            maxX = Math.max(bb.field_72336_d, maxX);
            maxY = Math.max(bb.field_72337_e, maxY);
            maxZ = Math.max(bb.field_72334_f, maxZ);
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private double getMovement(AxisAlignedBB bb1, Direction facing, AxisAlignedBB bb2) {
        switch (facing.func_176740_k()) {
            case X: {
                return MagnetizedBlockTileEntity.getDeltaX(bb1, facing, bb2);
            }
            case Z: {
                return MagnetizedBlockTileEntity.getDeltaZ(bb1, facing, bb2);
            }
        }
        return MagnetizedBlockTileEntity.getDeltaY(bb1, facing, bb2);
    }

    private AxisAlignedBB moveByPositionAndProgress(AxisAlignedBB bb) {
        double progress = this.getExtendedProgress(this.progress);
        return bb.func_72317_d((double)this.field_174879_c.func_177958_n() + progress * (double)this.magnetFacing.func_82601_c(), (double)this.field_174879_c.func_177956_o() + progress * (double)this.magnetFacing.func_96559_d(), (double)this.field_174879_c.func_177952_p() + progress * (double)this.magnetFacing.func_82599_e());
    }

    private AxisAlignedBB getMovementArea(AxisAlignedBB bb, Direction dir, double movement) {
        double d0 = movement * (double)dir.func_176743_c().func_179524_a();
        double d1 = Math.min(d0, 0.0);
        double d2 = Math.max(d0, 0.0);
        switch (dir) {
            case WEST: {
                return new AxisAlignedBB(bb.field_72340_a + d1, bb.field_72338_b, bb.field_72339_c, bb.field_72340_a + d2, bb.field_72337_e, bb.field_72334_f);
            }
            case EAST: {
                return new AxisAlignedBB(bb.field_72336_d + d1, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d + d2, bb.field_72337_e, bb.field_72334_f);
            }
            case DOWN: {
                return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b + d1, bb.field_72339_c, bb.field_72336_d, bb.field_72338_b + d2, bb.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c + d1, bb.field_72336_d, bb.field_72337_e, bb.field_72339_c + d2);
            }
            case SOUTH: {
                return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f + d1, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f + d2);
            }
        }
        return new AxisAlignedBB(bb.field_72340_a, bb.field_72337_e + d1, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e + d2, bb.field_72334_f);
    }

    private static double getDeltaX(AxisAlignedBB bb1, Direction facing, AxisAlignedBB bb2) {
        return facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? bb1.field_72336_d - bb2.field_72340_a : bb2.field_72336_d - bb1.field_72340_a;
    }

    private static double getDeltaY(AxisAlignedBB bb1, Direction facing, AxisAlignedBB bb2) {
        return facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? bb1.field_72337_e - bb2.field_72338_b : bb2.field_72337_e - bb1.field_72338_b;
    }

    private static double getDeltaZ(AxisAlignedBB bb1, Direction facing, AxisAlignedBB bb2) {
        return facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? bb1.field_72334_f - bb2.field_72339_c : bb2.field_72334_f - bb1.field_72339_c;
    }

    public BlockState getMagnetState() {
        return this.magnetState;
    }

    private IMagnetMoveAction getMoveAction() {
        Block block = this.magnetState.func_177230_c();
        if (block instanceof IMagnetMoveAction) {
            return (IMagnetMoveAction)block;
        }
        return MagnetSystem.getMoveAction(block);
    }

    public void finalizeContents(BlockState blockState) {
        IMagnetMoveAction action;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        SoundType soundType = blockState.func_215695_r();
        this.field_145850_b.func_184133_a(null, this.field_174879_c, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) * 0.05f, soundType.func_185847_b() * 0.8f);
        TileEntity newTile = this.getSubTile();
        if (newTile != null) {
            this.field_145850_b.func_175690_a(this.field_174879_c, newTile);
        }
        if ((action = this.getMoveAction()) != null) {
            action.onMagnetMoved(this.field_145850_b, this.field_174879_c, this.magnetFacing, blockState, newTile);
        }
    }

    public TileEntity getSubTile() {
        if (this.subTile != null && !this.subTile.isEmpty()) {
            CompoundNBT tileData = this.subTile.func_74737_b();
            tileData.func_74768_a("x", this.field_174879_c.func_177958_n());
            tileData.func_74768_a("y", this.field_174879_c.func_177956_o());
            tileData.func_74768_a("z", this.field_174879_c.func_177952_p());
            return TileEntity.func_235657_b_((BlockState)this.magnetState, (CompoundNBT)this.subTile);
        }
        return null;
    }

    public void clearMagnetTileEntity() {
        if (this.lastProgress < 1.0f && this.field_145850_b != null) {
            this.lastProgress = this.progress = 1.0f;
            this.field_145850_b.func_175713_t(this.field_174879_c);
            this.func_145843_s();
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == MagnetsModule.magnetized_block) {
                BlockState blockstate = Block.func_199770_b((BlockState)this.magnetState, (IWorld)this.field_145850_b, (BlockPos)this.field_174879_c);
                this.field_145850_b.func_180501_a(this.field_174879_c, blockstate, 3);
                this.field_145850_b.func_190524_a(this.field_174879_c, blockstate.func_177230_c(), this.field_174879_c);
                this.finalizeContents(blockstate);
            }
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        this.lastTicked = this.field_145850_b.func_82737_E();
        this.lastProgress = this.progress;
        if (this.lastProgress >= 1.0f) {
            this.field_145850_b.func_175713_t(this.field_174879_c);
            this.func_145843_s();
            if (this.magnetState != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == MagnetsModule.magnetized_block) {
                BlockState blockstate = Block.func_199770_b((BlockState)this.magnetState, (IWorld)this.field_145850_b, (BlockPos)this.field_174879_c);
                if (blockstate.func_196958_f()) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, this.magnetState, 84);
                    Block.func_196263_a((BlockState)this.magnetState, (BlockState)blockstate, (IWorld)this.field_145850_b, (BlockPos)this.field_174879_c, (int)3);
                } else {
                    if (blockstate.func_206871_b().containsKey((Object)BlockStateProperties.field_208198_y) && ((Boolean)blockstate.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                        blockstate = (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.FALSE);
                    }
                    this.field_145850_b.func_180501_a(this.field_174879_c, blockstate, 67);
                    this.field_145850_b.func_190524_a(this.field_174879_c, blockstate.func_177230_c(), this.field_174879_c);
                    this.finalizeContents(blockstate);
                }
            }
        } else {
            float newProgress = this.progress + 0.5f;
            this.moveCollidedEntities(newProgress);
            this.progress = newProgress;
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
            }
        }
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT compound) {
        super.func_230337_a_(p_230337_1_, compound);
        this.magnetState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("blockState"));
        this.magnetFacing = Direction.func_82600_a((int)compound.func_74762_e("facing"));
        this.lastProgress = this.progress = compound.func_74760_g("progress");
        this.subTile = compound.func_74775_l("subTile");
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.writeNBTData(super.func_189515_b(new CompoundNBT()), false);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        return this.writeNBTData(super.func_189515_b(new CompoundNBT()), true);
    }

    private CompoundNBT writeNBTData(CompoundNBT compound, boolean includeSubTile) {
        compound.func_218657_a("blockState", (INBT)NBTUtil.func_190009_a((BlockState)this.magnetState));
        if (includeSubTile) {
            compound.func_218657_a("subTile", (INBT)this.subTile);
        }
        compound.func_74768_a("facing", this.magnetFacing.func_176745_a());
        compound.func_74776_a("progress", this.lastProgress);
        return compound;
    }

    public VoxelShape getCollisionShape(IBlockReader world, BlockPos pos) {
        Direction direction = MOVING_ENTITY.get();
        if ((double)this.progress < 1.0 && direction == this.magnetFacing) {
            return VoxelShapes.func_197880_a();
        }
        float progress = this.getExtendedProgress(this.progress);
        double dX = (float)this.magnetFacing.func_82601_c() * progress;
        double dY = (float)this.magnetFacing.func_96559_d() * progress;
        double dZ = (float)this.magnetFacing.func_82599_e() * progress;
        return this.magnetState.func_196952_d(world, pos).func_197751_a(dX, dY, dZ);
    }

    public long getLastTicked() {
        return this.lastTicked;
    }
}

