/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.tile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import vazkii.arl.block.tile.TileSimpleInventory;
import vazkii.quark.base.client.NetworkProfilingHandler;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.oddities.block.PipeBlock;
import vazkii.quark.oddities.module.PipesModule;

public class PipeTileEntity
extends TileSimpleInventory
implements ITickableTileEntity {
    private static final String TAG_PIPE_ITEMS = "pipeItems";
    private boolean iterating = false;
    public final List<PipeItem> pipeItems = new LinkedList<PipeItem>();
    public final List<PipeItem> queuedItems = new LinkedList<PipeItem>();
    private boolean skipSync = false;

    public PipeTileEntity() {
        super(PipesModule.tileEntityType);
    }

    public static boolean isTheGoodDay(World world) {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 4 && calendar.get(5) == 1;
    }

    public void func_73660_a() {
        boolean enabled = this.isPipeEnabled();
        if (!enabled && this.field_145850_b.func_82737_E() % 10L == 0L && this.field_145850_b instanceof ServerWorld) {
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)new RedstoneParticleData(1.0f, 0.0f, 0.0f, 1.0f), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 3, 0.2, 0.2, 0.2, 0.0);
        }
        BlockState blockAt = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!this.field_145850_b.field_72995_K && enabled && blockAt.func_177230_c() instanceof PipeBlock) {
            for (Direction side : Direction.values()) {
                if (PipeTileEntity.getConnectionTo((IBlockReader)this.field_145850_b, this.field_174879_c, side) != ConnectionType.OPENING) continue;
                double minX = (double)this.field_174879_c.func_177958_n() + 0.25 + 0.5 * (double)Math.min(0, side.func_82601_c());
                double minY = (double)this.field_174879_c.func_177956_o() + 0.25 + 0.5 * (double)Math.min(0, side.func_96559_d());
                double minZ = (double)this.field_174879_c.func_177952_p() + 0.25 + 0.5 * (double)Math.min(0, side.func_82599_e());
                double maxX = (double)this.field_174879_c.func_177958_n() + 0.75 + 0.5 * (double)Math.max(0, side.func_82601_c());
                double maxY = (double)this.field_174879_c.func_177956_o() + 0.75 + 0.5 * (double)Math.max(0, side.func_96559_d());
                double maxZ = (double)this.field_174879_c.func_177952_p() + 0.75 + 0.5 * (double)Math.max(0, side.func_82599_e());
                Direction opposite = side.func_176734_d();
                boolean pickedItemsUp = false;
                com.google.common.base.Predicate predicate = entity -> {
                    if (entity == null || !entity.func_70089_S()) {
                        return false;
                    }
                    Vector3d motion = entity.func_213322_ci();
                    Direction dir = Direction.func_210769_a((double)motion.field_72450_a, (double)motion.field_72448_b, (double)motion.field_72449_c);
                    return dir == opposite;
                };
                for (ItemEntity item : this.field_145850_b.func_175647_a(ItemEntity.class, new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ), (Predicate)predicate)) {
                    this.passIn(item.func_92059_d().func_77946_l(), side);
                    if (PipesModule.doPipesWhoosh) {
                        if (PipeTileEntity.isTheGoodDay(this.field_145850_b)) {
                            this.field_145850_b.func_184148_a(null, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), QuarkSounds.BLOCK_PIPE_PICKUP_LENNY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        } else {
                            this.field_145850_b.func_184148_a(null, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), QuarkSounds.BLOCK_PIPE_PICKUP, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                    pickedItemsUp = true;
                    item.func_70106_y();
                }
                if (!pickedItemsUp) continue;
                this.sync();
            }
        }
        int currentOut = this.getComparatorOutput();
        if (!this.pipeItems.isEmpty()) {
            if (PipesModule.maxPipeItems > 0 && this.pipeItems.size() > PipesModule.maxPipeItems && !this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_217379_c(2001, this.field_174879_c, Block.func_196246_j((BlockState)this.field_145850_b.func_180495_p(this.field_174879_c)));
                this.dropItem(new ItemStack((IItemProvider)this.func_195044_w().func_177230_c()));
                this.field_145850_b.func_217377_a(this.func_174877_v(), false);
            }
            ListIterator<PipeItem> itemItr = this.pipeItems.listIterator();
            this.iterating = true;
            while (itemItr.hasNext()) {
                PipeItem item = itemItr.next();
                Direction lastFacing = item.outgoingFace;
                if (!item.tick(this)) continue;
                itemItr.remove();
                if (item.valid) {
                    this.passOut(item);
                    continue;
                }
                this.dropItem(item.stack, lastFacing, true);
            }
            this.iterating = false;
            this.pipeItems.addAll(this.queuedItems);
            this.queuedItems.clear();
        }
        if (this.getComparatorOutput() != currentOut) {
            this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
        }
    }

    public int getComparatorOutput() {
        return Math.min(15, this.pipeItems.size());
    }

    public Iterator<PipeItem> getItemIterator() {
        return this.pipeItems.iterator();
    }

    public boolean passIn(ItemStack stack, Direction face, Direction backlog, long seed, int time) {
        PipeItem item = new PipeItem(stack, face, seed);
        item.backloggedFace = backlog;
        if (!this.iterating) {
            int currentOut = this.getComparatorOutput();
            this.pipeItems.add(item);
            item.timeInWorld = time;
            if (this.getComparatorOutput() != currentOut) {
                this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
            }
        } else {
            this.queuedItems.add(item);
        }
        return true;
    }

    public boolean passIn(ItemStack stack, Direction face) {
        return this.passIn(stack, face, null, this.field_145850_b.field_73012_v.nextLong(), 0);
    }

    protected void passOut(PipeItem item) {
        BlockPos targetPos = this.func_174877_v().func_177972_a(item.outgoingFace);
        TileEntity tile = this.field_145850_b.func_175625_s(targetPos);
        boolean did = false;
        if (tile != null) {
            if (tile instanceof PipeTileEntity) {
                did = ((PipeTileEntity)tile).passIn(item.stack, item.outgoingFace.func_176734_d(), null, item.rngSeed, item.timeInWorld);
            } else {
                ItemStack result = this.putIntoInv(item.stack, tile, item.outgoingFace.func_176734_d(), false);
                if (result.func_190916_E() != item.stack.func_190916_E()) {
                    did = true;
                    if (!result.func_190926_b()) {
                        this.bounceBack(item, result);
                    }
                }
            }
        }
        if (!did) {
            this.bounceBack(item, null);
        }
    }

    private void bounceBack(PipeItem item, ItemStack stack) {
        if (!this.field_145850_b.field_72995_K) {
            this.passIn(stack == null ? item.stack : stack, item.outgoingFace, item.incomingFace, item.rngSeed, item.timeInWorld);
            this.sync();
        }
    }

    public void dropItem(ItemStack stack) {
        this.dropItem(stack, null, false);
    }

    public void dropItem(ItemStack stack, Direction facing, boolean playSound) {
        if (!this.field_145850_b.field_72995_K) {
            double posX = (double)this.field_174879_c.func_177958_n() + 0.5;
            double posY = (double)this.field_174879_c.func_177956_o() + 0.25;
            double posZ = (double)this.field_174879_c.func_177952_p() + 0.5;
            if (facing != null) {
                posX -= (double)facing.func_82601_c() * 0.4;
                posY -= (double)facing.func_96559_d() * 0.65;
                posZ -= (double)facing.func_82599_e() * 0.4;
            }
            boolean shootOut = this.isPipeEnabled();
            float pitch = 1.0f;
            if (!shootOut) {
                pitch = 0.025f;
            }
            if (playSound && PipesModule.doPipesWhoosh) {
                if (PipeTileEntity.isTheGoodDay(this.field_145850_b)) {
                    this.field_145850_b.func_184148_a(null, posX, posY, posZ, QuarkSounds.BLOCK_PIPE_SHOOT_LENNY, SoundCategory.BLOCKS, 1.0f, pitch);
                } else {
                    this.field_145850_b.func_184148_a(null, posX, posY, posZ, QuarkSounds.BLOCK_PIPE_SHOOT, SoundCategory.BLOCKS, 1.0f, pitch);
                }
            }
            ItemEntity entity = new ItemEntity(this.field_145850_b, posX, posY, posZ, stack);
            entity.func_174869_p();
            double velocityMod = 0.5;
            if (!shootOut) {
                velocityMod = 0.125;
            }
            if (facing != null) {
                double mx = (double)(-facing.func_82601_c()) * velocityMod;
                double my = (double)(-facing.func_96559_d()) * velocityMod;
                double mz = (double)(-facing.func_82599_e()) * velocityMod;
                entity.func_213293_j(mx, my, mz);
            }
            this.field_145850_b.func_217376_c((Entity)entity);
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        NetworkProfilingHandler.receive("pipe");
    }

    public void dropAllItems() {
        for (PipeItem item : this.pipeItems) {
            this.dropItem(item.stack);
        }
        this.pipeItems.clear();
    }

    public void readSharedNBT(CompoundNBT cmp) {
        this.skipSync = true;
        super.readSharedNBT(cmp);
        this.skipSync = false;
        ListNBT pipeItemList = cmp.func_150295_c(TAG_PIPE_ITEMS, (int)cmp.func_74732_a());
        this.pipeItems.clear();
        pipeItemList.forEach(listCmp -> {
            PipeItem item = PipeItem.readFromNBT((CompoundNBT)listCmp);
            this.pipeItems.add(item);
        });
    }

    public void writeSharedNBT(CompoundNBT cmp) {
        super.writeSharedNBT(cmp);
        ListNBT pipeItemList = new ListNBT();
        for (PipeItem item : this.pipeItems) {
            CompoundNBT listCmp = new CompoundNBT();
            item.writeToNBT(listCmp);
            pipeItemList.add((Object)listCmp);
        }
        cmp.func_218657_a(TAG_PIPE_ITEMS, (INBT)pipeItemList);
    }

    protected boolean canFit(ItemStack stack, BlockPos pos, Direction face) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile == null) {
            return false;
        }
        if (tile instanceof PipeTileEntity) {
            return ((PipeTileEntity)tile).isPipeEnabled();
        }
        ItemStack result = this.putIntoInv(stack, tile, face, true);
        return result.func_190926_b();
    }

    protected boolean isPipeEnabled() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return state.func_177230_c() instanceof PipeBlock && !this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    protected ItemStack putIntoInv(ItemStack stack, TileEntity tile, Direction face, boolean simulate) {
        IItemHandler handler = null;
        LazyOptional opt = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
        if (opt.isPresent()) {
            handler = (IItemHandler)opt.orElse(null);
        } else if (tile instanceof ISidedInventory) {
            handler = new SidedInvWrapper((ISidedInventory)tile, face);
        } else if (tile instanceof IInventory) {
            handler = new InvWrapper((IInventory)tile);
        }
        if (handler != null) {
            return simulate ? ItemStack.field_190927_a : ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
        }
        return stack;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull Direction direction) {
        return index == direction.ordinal() && this.isPipeEnabled();
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemstack) {
        if (!itemstack.func_190926_b()) {
            Direction side = Direction.values()[i];
            this.passIn(itemstack, side);
            if (!this.field_145850_b.field_72995_K && !this.skipSync) {
                this.sync();
            }
        }
    }

    public int func_70302_i_() {
        return 6;
    }

    protected boolean needsToSyncInventory() {
        return true;
    }

    public void sync() {
        MiscUtil.syncTE((TileEntity)this);
    }

    public static ConnectionType getConnectionTo(IBlockReader world, BlockPos pos, Direction face) {
        return PipeTileEntity.getConnectionTo(world, pos, face, false);
    }

    private static ConnectionType getConnectionTo(IBlockReader world, BlockPos pos, Direction face, boolean recursed) {
        block7: {
            BlockPos truePos = pos.func_177972_a(face);
            TileEntity tile = world.func_175625_s(truePos);
            if (tile != null) {
                if (tile instanceof PipeTileEntity) {
                    return ConnectionType.PIPE;
                }
                if (tile instanceof IInventory || tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d()).isPresent()) {
                    return tile instanceof ChestTileEntity ? ConnectionType.TERMINAL_OFFSET : ConnectionType.TERMINAL;
                }
            }
            if (!recursed) {
                ConnectionType other = PipeTileEntity.getConnectionTo(world, pos, face.func_176734_d(), true);
                if (other.isSolid) {
                    for (Direction d : Direction.values()) {
                        if (d.func_176740_k() == face.func_176740_k()) continue;
                        other = PipeTileEntity.getConnectionTo(world, pos, d, true);
                        if (!other.isSolid) {
                            continue;
                        }
                        break block7;
                    }
                    return ConnectionType.OPENING;
                }
            }
        }
        return ConnectionType.NONE;
    }

    public static enum ConnectionType {
        NONE(false, false, false, 0.0),
        PIPE(true, true, false, 0.0),
        OPENING(false, true, true, -0.125),
        TERMINAL(true, true, true, 0.125),
        TERMINAL_OFFSET(true, true, true, 0.1875);

        public final boolean isSolid;
        public final boolean allowsItems;
        public final boolean isFlared;
        public final double flareShift;

        private ConnectionType(boolean isSolid, boolean allowsItems, boolean isFlared, double flareShift) {
            this.isSolid = isSolid;
            this.allowsItems = allowsItems;
            this.isFlared = isFlared;
            this.flareShift = flareShift;
        }
    }

    public static class PipeItem {
        private static final String TAG_TICKS = "ticksInPipe";
        private static final String TAG_INCOMING = "incomingFace";
        private static final String TAG_OUTGOING = "outgoingFace";
        private static final String TAG_BACKLOGGED = "backloggedFace";
        private static final String TAG_RNG_SEED = "rngSeed";
        private static final String TAG_TIME_IN_WORLD = "timeInWorld";
        private static final List<Direction> HORIZONTAL_SIDES_LIST = Arrays.asList(MiscUtil.HORIZONTALS);
        public final ItemStack stack;
        public int ticksInPipe;
        public final Direction incomingFace;
        public Direction outgoingFace;
        public Direction backloggedFace;
        public long rngSeed;
        public int timeInWorld = 0;
        public boolean valid = true;

        public PipeItem(ItemStack stack, Direction face, long rngSeed) {
            this.stack = stack;
            this.ticksInPipe = 0;
            this.incomingFace = this.outgoingFace = face;
            this.rngSeed = rngSeed;
        }

        protected boolean tick(PipeTileEntity pipe) {
            ++this.ticksInPipe;
            ++this.timeInWorld;
            if (this.ticksInPipe == PipesModule.effectivePipeSpeed / 2 - 1) {
                Direction target;
                this.outgoingFace = target = this.getTargetFace(pipe);
            }
            if (this.outgoingFace == null) {
                this.valid = false;
                return true;
            }
            return this.ticksInPipe >= PipesModule.effectivePipeSpeed;
        }

        protected Direction getTargetFace(PipeTileEntity pipe) {
            BlockPos pipePos = pipe.func_174877_v();
            if (this.incomingFace != Direction.DOWN && this.backloggedFace != Direction.DOWN && pipe.canFit(this.stack, pipePos.func_177972_a(Direction.DOWN), Direction.UP)) {
                return Direction.DOWN;
            }
            Direction incomingOpposite = this.incomingFace;
            if (this.incomingFace.func_176740_k() != Direction.Axis.Y && (incomingOpposite = this.incomingFace.func_176734_d()) != this.backloggedFace && pipe.canFit(this.stack, pipePos.func_177972_a(incomingOpposite), this.incomingFace)) {
                return incomingOpposite;
            }
            ArrayList<Direction> sides = new ArrayList<Direction>(HORIZONTAL_SIDES_LIST);
            sides.remove(this.incomingFace);
            sides.remove(incomingOpposite);
            Random rng = new Random(this.rngSeed);
            this.rngSeed = rng.nextLong();
            Collections.shuffle(sides, rng);
            for (Direction side : sides) {
                if (side == this.backloggedFace || !pipe.canFit(this.stack, pipePos.func_177972_a(side), side.func_176734_d())) continue;
                return side;
            }
            if (this.incomingFace != Direction.UP && this.backloggedFace != Direction.UP && pipe.canFit(this.stack, pipePos.func_177972_a(Direction.UP), Direction.DOWN)) {
                return Direction.UP;
            }
            if (this.backloggedFace != null) {
                return this.backloggedFace;
            }
            return null;
        }

        public float getTimeFract(float partial) {
            return ((float)this.ticksInPipe + partial) / (float)PipesModule.effectivePipeSpeed;
        }

        public void writeToNBT(CompoundNBT cmp) {
            this.stack.func_77955_b(cmp);
            cmp.func_74768_a(TAG_TICKS, this.ticksInPipe);
            cmp.func_74768_a(TAG_INCOMING, this.incomingFace.ordinal());
            cmp.func_74768_a(TAG_OUTGOING, this.outgoingFace.ordinal());
            cmp.func_74768_a(TAG_BACKLOGGED, this.backloggedFace != null ? this.backloggedFace.ordinal() : -1);
            cmp.func_74772_a(TAG_RNG_SEED, this.rngSeed);
            cmp.func_74768_a(TAG_TIME_IN_WORLD, this.timeInWorld);
        }

        public static PipeItem readFromNBT(CompoundNBT cmp) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)cmp);
            Direction inFace = Direction.values()[cmp.func_74762_e(TAG_INCOMING)];
            long rngSeed = cmp.func_74763_f(TAG_RNG_SEED);
            PipeItem item = new PipeItem(stack, inFace, rngSeed);
            item.ticksInPipe = cmp.func_74762_e(TAG_TICKS);
            item.outgoingFace = Direction.values()[cmp.func_74762_e(TAG_OUTGOING)];
            item.timeInWorld = cmp.func_74762_e(TAG_TIME_IN_WORLD);
            int backloggedId = cmp.func_74762_e(TAG_BACKLOGGED);
            item.backloggedFace = backloggedId == -1 ? null : Direction.values()[backloggedId];
            return item;
        }
    }
}

