/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tools.client;

import com.google.common.base.Function;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlintRenderType {
    public static List<RenderType> glintColor = GlintRenderType.newRenderList((Function<String, RenderType>)((Function)GlintRenderType::buildGlintRenderType));
    public static List<RenderType> entityGlintColor = GlintRenderType.newRenderList((Function<String, RenderType>)((Function)GlintRenderType::buildEntityGlintRenderType));
    public static List<RenderType> glintDirectColor = GlintRenderType.newRenderList((Function<String, RenderType>)((Function)GlintRenderType::buildGlintDirectRenderType));
    public static List<RenderType> entityGlintDirectColor = GlintRenderType.newRenderList((Function<String, RenderType>)((Function)GlintRenderType::buildEntityGlintDriectRenderType));
    public static List<RenderType> armorGlintColor = GlintRenderType.newRenderList((Function<String, RenderType>)((Function)GlintRenderType::buildArmorGlintRenderType));
    public static List<RenderType> armorEntityGlintColor = GlintRenderType.newRenderList((Function<String, RenderType>)((Function)GlintRenderType::buildArmorEntityGlintRenderType));

    public static void addGlintTypes(Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder> map) {
        GlintRenderType.addGlintTypes(map, glintColor);
        GlintRenderType.addGlintTypes(map, entityGlintColor);
        GlintRenderType.addGlintTypes(map, glintDirectColor);
        GlintRenderType.addGlintTypes(map, entityGlintDirectColor);
        GlintRenderType.addGlintTypes(map, armorGlintColor);
        GlintRenderType.addGlintTypes(map, armorEntityGlintColor);
    }

    private static List<RenderType> newRenderList(Function<String, RenderType> func) {
        ArrayList<RenderType> list = new ArrayList<RenderType>(17);
        for (DyeColor color : DyeColor.values()) {
            list.add((RenderType)func.apply((Object)color.func_176762_d()));
        }
        list.add((RenderType)func.apply((Object)"rainbow"));
        return list;
    }

    private static void addGlintTypes(Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder> map, List<RenderType> typeList) {
        for (RenderType renderType : typeList) {
            if (map.containsKey((Object)renderType)) continue;
            map.put((Object)renderType, (Object)new BufferBuilder(renderType.func_228662_o_()));
        }
    }

    private static RenderType buildGlintRenderType(String name) {
        ResourceLocation res = new ResourceLocation("quark", "textures/glint/enchanted_item_glint_" + name + ".png");
        return RenderType.func_228632_a_((String)("glint_" + name), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(res, true, false)).func_228727_a_(RenderState.field_228496_F_).func_228714_a_(RenderState.field_228491_A_).func_228715_a_(RenderState.field_228493_C_).func_228726_a_(RenderState.field_228513_e_).func_228721_a_(RenderState.field_241712_U_).func_228725_a_(RenderState.field_228526_r_).func_228728_a_(false));
    }

    private static RenderType buildEntityGlintRenderType(String name) {
        ResourceLocation res = new ResourceLocation("quark", "textures/glint/enchanted_item_glint_" + name + ".png");
        return RenderType.func_228632_a_((String)("entity_glint_" + name), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(res, true, false)).func_228727_a_(RenderState.field_228496_F_).func_228714_a_(RenderState.field_228491_A_).func_228715_a_(RenderState.field_228493_C_).func_228726_a_(RenderState.field_228513_e_).func_228721_a_(RenderState.field_241712_U_).func_228725_a_(RenderState.field_228527_s_).func_228728_a_(false));
    }

    private static RenderType buildGlintDirectRenderType(String name) {
        ResourceLocation res = new ResourceLocation("quark", "textures/glint/enchanted_item_glint_" + name + ".png");
        return RenderType.func_228632_a_((String)("glint_direct_" + name), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(res, true, false)).func_228727_a_(RenderState.field_228496_F_).func_228714_a_(RenderState.field_228491_A_).func_228715_a_(RenderState.field_228493_C_).func_228726_a_(RenderState.field_228513_e_).func_228725_a_(RenderState.field_228526_r_).func_228728_a_(false));
    }

    private static RenderType buildEntityGlintDriectRenderType(String name) {
        ResourceLocation res = new ResourceLocation("quark", "textures/glint/enchanted_item_glint_" + name + ".png");
        return RenderType.func_228632_a_((String)("entity_glint_direct_" + name), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(res, true, false)).func_228727_a_(RenderState.field_228496_F_).func_228714_a_(RenderState.field_228491_A_).func_228715_a_(RenderState.field_228493_C_).func_228726_a_(RenderState.field_228513_e_).func_228725_a_(RenderState.field_228527_s_).func_228728_a_(false));
    }

    private static RenderType buildArmorGlintRenderType(String name) {
        ResourceLocation res = new ResourceLocation("quark", "textures/glint/enchanted_item_glint_" + name + ".png");
        return RenderType.func_228632_a_((String)("entity_glint_direct_" + name), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(res, true, false)).func_228727_a_(RenderState.field_228496_F_).func_228714_a_(RenderState.field_228491_A_).func_228715_a_(RenderState.field_228493_C_).func_228726_a_(RenderState.field_228513_e_).func_228725_a_(RenderState.field_228527_s_).func_228718_a_(RenderState.field_239235_M_).func_228728_a_(false));
    }

    private static RenderType buildArmorEntityGlintRenderType(String name) {
        ResourceLocation res = new ResourceLocation("quark", "textures/glint/enchanted_item_glint_" + name + ".png");
        return RenderType.func_228632_a_((String)("entity_glint_direct_" + name), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(res, true, false)).func_228727_a_(RenderState.field_228496_F_).func_228714_a_(RenderState.field_228491_A_).func_228715_a_(RenderState.field_228493_C_).func_228726_a_(RenderState.field_228513_e_).func_228725_a_(RenderState.field_228527_s_).func_228718_a_(RenderState.field_239235_M_).func_228728_a_(false));
    }
}

