/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tools.module;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TagLootEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.api.IRuneColorProvider;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.tools.client.GlintRenderType;
import vazkii.quark.tools.item.RuneItem;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class ColorRunesModule
extends Module {
    public static final String TAG_RUNE_ATTACHED = "quark:RuneAttached";
    public static final String TAG_RUNE_COLOR = "quark:RuneColor";
    private static final ThreadLocal<ItemStack> targetStack = new ThreadLocal();
    public static ITag<Item> runesTag;
    public static ITag<Item> runesLootableTag;
    @Config
    public static int dungeonWeight;
    @Config
    public static int netherFortressWeight;
    @Config
    public static int jungleTempleWeight;
    @Config
    public static int desertTempleWeight;
    @Config
    public static int itemQuality;
    @Config
    public static int applyCost;

    public static void setTargetStack(ItemStack stack) {
        targetStack.set(stack);
    }

    public static int changeColor() {
        ItemStack target = targetStack.get();
        if (target == null) {
            return -1;
        }
        LazyOptional<IRuneColorProvider> cap = ColorRunesModule.get((ICapabilityProvider)target);
        if (cap.isPresent()) {
            return ((IRuneColorProvider)cap.orElse(s -> -1)).getRuneColor(target);
        }
        if (!ItemNBTHelper.getBoolean((ItemStack)target, (String)TAG_RUNE_ATTACHED, (boolean)false)) {
            return -1;
        }
        ItemStack proxied = ItemStack.func_199557_a((CompoundNBT)ItemNBTHelper.getCompound((ItemStack)target, (String)TAG_RUNE_COLOR, (boolean)false));
        LazyOptional<IRuneColorProvider> proxyCap = ColorRunesModule.get((ICapabilityProvider)proxied);
        return ((IRuneColorProvider)proxyCap.orElse(s -> -1)).getRuneColor(target);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getGlint() {
        int color = ColorRunesModule.changeColor();
        return color >= 0 && color <= 16 ? GlintRenderType.glintColor.get(color) : RenderType.func_228653_j_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getEntityGlint() {
        int color = ColorRunesModule.changeColor();
        return color >= 0 && color <= 16 ? GlintRenderType.entityGlintColor.get(color) : RenderType.func_228655_k_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getGlintDirect() {
        int color = ColorRunesModule.changeColor();
        return color >= 0 && color <= 16 ? GlintRenderType.glintDirectColor.get(color) : RenderType.func_239273_n_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getEntityGlintDirect() {
        int color = ColorRunesModule.changeColor();
        return color >= 0 && color <= 16 ? GlintRenderType.entityGlintDirectColor.get(color) : RenderType.func_239274_p_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getArmorGlint() {
        int color = ColorRunesModule.changeColor();
        return color >= 0 && color <= 16 ? GlintRenderType.armorGlintColor.get(color) : RenderType.func_239270_k_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getArmorEntityGlint() {
        int color = ColorRunesModule.changeColor();
        return color >= 0 && color <= 16 ? GlintRenderType.armorEntityGlintColor.get(color) : RenderType.func_239271_l_();
    }

    @Override
    public void construct() {
        for (DyeColor color : DyeColor.values()) {
            new RuneItem(color.func_176610_l() + "_rune", (Module)this, color.func_196059_a());
        }
        new RuneItem("rainbow_rune", (Module)this, 16);
    }

    @Override
    public void setup() {
        runesTag = ItemTags.createOptional((ResourceLocation)new ResourceLocation("quark", "runes"));
        runesLootableTag = ItemTags.createOptional((ResourceLocation)new ResourceLocation("quark", "runes_lootable"));
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        int weight = 0;
        if (event.getName().equals((Object)LootTables.field_186422_d)) {
            weight = dungeonWeight;
        } else if (event.getName().equals((Object)LootTables.field_186425_g)) {
            weight = netherFortressWeight;
        } else if (event.getName().equals((Object)LootTables.field_186430_l)) {
            weight = jungleTempleWeight;
        } else if (event.getName().equals((Object)LootTables.field_186429_k)) {
            weight = desertTempleWeight;
        }
        if (weight > 0) {
            LootEntry entry = TagLootEntry.func_216176_b(runesLootableTag).func_216086_a(weight).func_216085_b(itemQuality).func_216081_b();
            MiscUtil.addToLootTable(event.getTable(), entry);
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        ItemStack output = event.getOutput();
        if (!left.func_190926_b() && !right.func_190926_b() && left.func_77948_v() && right.func_77973_b().func_206844_a(runesTag)) {
            ItemStack out = (output.func_190926_b() ? left : output).func_77946_l();
            ItemNBTHelper.setBoolean((ItemStack)out, (String)TAG_RUNE_ATTACHED, (boolean)true);
            ItemNBTHelper.setCompound((ItemStack)out, (String)TAG_RUNE_COLOR, (CompoundNBT)right.serializeNBT());
            event.setOutput(out);
            event.setCost(applyCost);
            event.setMaterialCost(1);
        }
    }

    private static LazyOptional<IRuneColorProvider> get(ICapabilityProvider provider) {
        return provider.getCapability(QuarkCapabilities.RUNE_COLOR);
    }

    static {
        dungeonWeight = 10;
        netherFortressWeight = 8;
        jungleTempleWeight = 8;
        desertTempleWeight = 8;
        itemQuality = 0;
        applyCost = 15;
    }
}

