/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.client.emote;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.tweaks.client.emote.CustomEmoteDescriptor;
import vazkii.quark.tweaks.client.emote.EmoteBase;
import vazkii.quark.tweaks.client.emote.EmoteDescriptor;
import vazkii.quark.tweaks.client.emote.ModelAccessor;
import vazkii.quark.tweaks.client.emote.TemplateSourcedEmote;

@OnlyIn(value=Dist.CLIENT)
public final class EmoteHandler {
    public static final String CUSTOM_EMOTE_NAMESPACE = "quark_custom";
    public static final String CUSTOM_PREFIX = "custom:";
    public static final Map<String, EmoteDescriptor> emoteMap = new LinkedHashMap<String, EmoteDescriptor>();
    private static final Map<String, EmoteBase> playerEmotes = new HashMap<String, EmoteBase>();
    private static int count;

    public static void clearEmotes() {
        emoteMap.clear();
    }

    public static void addEmote(String name, Class<? extends EmoteBase> clazz) {
        EmoteDescriptor desc = new EmoteDescriptor(clazz, name, name, count++);
        emoteMap.put(name, desc);
    }

    public static void addEmote(String name) {
        EmoteHandler.addEmote(name, TemplateSourcedEmote.class);
    }

    public static void addCustomEmote(String name) {
        String reg = CUSTOM_PREFIX + name;
        CustomEmoteDescriptor desc = new CustomEmoteDescriptor(name, reg, count++);
        emoteMap.put(reg, desc);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void putEmote(Entity player, String emoteName, int tier) {
        if (player instanceof AbstractClientPlayerEntity && emoteMap.containsKey(emoteName)) {
            EmoteHandler.putEmote((AbstractClientPlayerEntity)player, emoteMap.get(emoteName), tier);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void putEmote(AbstractClientPlayerEntity player, EmoteDescriptor desc, int tier) {
        String name = player.func_146103_bH().getName();
        if (desc == null) {
            return;
        }
        if (desc.getTier() > tier) {
            return;
        }
        BipedModel<?> model = EmoteHandler.getPlayerModel(player);
        BipedModel<?> armorModel = EmoteHandler.getPlayerArmorModel(player);
        BipedModel<?> armorLegModel = EmoteHandler.getPlayerArmorLegModel(player);
        if (model != null && armorModel != null && armorLegModel != null) {
            EmoteHandler.resetPlayer(player);
            EmoteBase emote = desc.instantiate((PlayerEntity)player, model, armorModel, armorLegModel);
            emote.startAllTimelines();
            playerEmotes.put(name, emote);
        }
    }

    public static void updateEmotes(Entity e) {
        if (e instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)e;
            String name = player.func_146103_bH().getName();
            if (player.func_213283_Z() == Pose.STANDING) {
                EmoteBase emote;
                boolean done;
                EmoteHandler.resetPlayer(player);
                if (playerEmotes.containsKey(name) && !(done = (emote = playerEmotes.get(name)).isDone())) {
                    emote.update();
                }
            }
        }
    }

    public static void preRender(PlayerEntity player) {
        EmoteBase emote = EmoteHandler.getPlayerEmote(player);
        if (emote != null) {
            RenderSystem.pushMatrix();
            emote.rotateAndOffset();
        }
    }

    public static void postRender(PlayerEntity player) {
        EmoteBase emote = EmoteHandler.getPlayerEmote(player);
        if (emote != null) {
            RenderSystem.popMatrix();
        }
    }

    public static void onRenderTick(Minecraft mc) {
        ClientWorld world = mc.field_71441_e;
        if (world == null) {
            return;
        }
        for (PlayerEntity player : world.func_217369_A()) {
            EmoteHandler.updatePlayerStatus(player);
        }
    }

    private static void updatePlayerStatus(PlayerEntity e) {
        if (e instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)e;
            String name = player.func_146103_bH().getName();
            if (playerEmotes.containsKey(name)) {
                EmoteBase emote = playerEmotes.get(name);
                boolean done = emote.isDone();
                if (done) {
                    playerEmotes.remove(name);
                    EmoteHandler.resetPlayer(player);
                } else {
                    emote.update();
                }
            } else {
                EmoteHandler.resetPlayer(player);
            }
        }
    }

    public static EmoteBase getPlayerEmote(PlayerEntity player) {
        return playerEmotes.get(player.func_146103_bH().getName());
    }

    private static PlayerRenderer getRenderPlayer(AbstractClientPlayerEntity player) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityRendererManager manager = mc.func_175598_ae();
        return (PlayerRenderer)manager.getSkinMap().get(player.func_175154_l());
    }

    private static BipedModel<?> getPlayerModel(AbstractClientPlayerEntity player) {
        PlayerRenderer render = EmoteHandler.getRenderPlayer(player);
        if (render != null) {
            return (BipedModel)render.func_217764_d();
        }
        return null;
    }

    private static BipedModel<?> getPlayerArmorModel(AbstractClientPlayerEntity player) {
        return EmoteHandler.getPlayerArmorModelForSlot(player, EquipmentSlotType.CHEST);
    }

    private static BipedModel<?> getPlayerArmorLegModel(AbstractClientPlayerEntity player) {
        return EmoteHandler.getPlayerArmorModelForSlot(player, EquipmentSlotType.LEGS);
    }

    private static BipedModel<?> getPlayerArmorModelForSlot(AbstractClientPlayerEntity player, EquipmentSlotType slot) {
        PlayerRenderer render = EmoteHandler.getRenderPlayer(player);
        if (render == null) {
            return null;
        }
        List list = render.field_177097_h;
        for (LayerRenderer r : list) {
            if (!(r instanceof BipedArmorLayer)) continue;
            return ((BipedArmorLayer)r).func_241736_a_(slot);
        }
        return null;
    }

    private static void resetPlayer(AbstractClientPlayerEntity player) {
        EmoteHandler.resetModel(EmoteHandler.getPlayerModel(player));
        EmoteHandler.resetModel(EmoteHandler.getPlayerArmorModel(player));
        EmoteHandler.resetModel(EmoteHandler.getPlayerArmorLegModel(player));
    }

    private static void resetModel(BipedModel<?> model) {
        if (model != null) {
            EmoteHandler.resetPart(model.field_78116_c);
            EmoteHandler.resetPart(model.field_178720_f);
            EmoteHandler.resetPart(model.field_78115_e);
            EmoteHandler.resetPart(model.field_178724_i);
            EmoteHandler.resetPart(model.field_178723_h);
            EmoteHandler.resetPart(model.field_178722_k);
            EmoteHandler.resetPart(model.field_178721_j);
            if (model instanceof PlayerModel) {
                PlayerModel pmodel = (PlayerModel)model;
                EmoteHandler.resetPart(pmodel.field_178730_v);
                EmoteHandler.resetPart(pmodel.field_178734_a);
                EmoteHandler.resetPart(pmodel.field_178732_b);
                EmoteHandler.resetPart(pmodel.field_178733_c);
                EmoteHandler.resetPart(pmodel.field_178731_d);
            }
            ModelAccessor.INSTANCE.resetModel(model);
        }
    }

    private static void resetPart(ModelRenderer part) {
        if (part != null) {
            part.field_78808_h = 0.0f;
        }
    }
}

