/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.module;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class InfinityBucketModule
extends Module {
    private static Map<Pair<PlayerEntity, Hand>, Pair<Integer, ItemStack>> bukkitPlayers = new HashMap<Pair<PlayerEntity, Hand>, Pair<Integer, ItemStack>>();
    @Config
    public static int cost = 10;
    @Config(description="Set this to false to prevent dispensers from using infinite water buckets")
    public static boolean allowDispensersToUse = true;

    @Override
    public void loadComplete() {
        if (this.enabled) {
            DefaultDispenseItemBehavior behaviour = new DefaultDispenseItemBehavior(){
                private final DefaultDispenseItemBehavior field_239793_b_ = new DefaultDispenseItemBehavior();

                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    boolean returnItself = false;
                    if (InfinityBucketModule.this.enabled && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0) {
                        if (!allowDispensersToUse) {
                            return this.field_239793_b_.dispense(source, stack);
                        }
                        returnItself = true;
                    }
                    ItemStack copy = stack.func_77946_l();
                    BucketItem bucketitem = (BucketItem)stack.func_77973_b();
                    BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                    ServerWorld world = source.func_197524_h();
                    if (bucketitem.func_180616_a(null, (World)world, blockpos, null)) {
                        bucketitem.func_203792_a((World)world, stack, blockpos);
                        return returnItself ? copy : new ItemStack((IItemProvider)Items.field_151133_ar);
                    }
                    return this.field_239793_b_.dispense(source, stack);
                }
            };
            Map registry = DispenserBlock.field_149943_a;
            registry.put(Items.field_151131_as, behaviour);
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_77973_b() == Items.field_151131_as && right.func_77973_b() == Items.field_151134_bR && (Integer)EnchantmentHelper.func_82781_a((ItemStack)right).get(Enchantments.field_185312_x) > 0) {
            ItemStack result = left.func_77946_l();
            HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
            map.put(Enchantments.field_185312_x, 1);
            EnchantmentHelper.func_82782_a(map, (ItemStack)result);
            event.setOutput(result);
            event.setCost(cost);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        PlayerEntity player = event.player;
        int slot = player.field_71071_by.field_70461_c;
        for (Hand hand : Hand.values()) {
            Pair<Integer, ItemStack> resultPair;
            Pair pair = Pair.of((Object)player, (Object)hand);
            if (!bukkitPlayers.containsKey(pair)) continue;
            ItemStack curr = player.func_184586_b(hand);
            if (curr.func_77973_b() == Items.field_151133_ar && (Integer)(resultPair = bukkitPlayers.get(pair)).getLeft() == slot) {
                player.func_184611_a(hand, (ItemStack)resultPair.getRight());
            }
            bukkitPlayers.remove(pair);
        }
        for (Hand hand : Hand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() != Items.field_151131_as || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) <= 0) continue;
            bukkitPlayers.put((Pair<PlayerEntity, Hand>)Pair.of((Object)player, (Object)hand), (Pair<Integer, ItemStack>)Pair.of((Object)slot, (Object)stack.func_77946_l()));
        }
    }
}

