/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.block;

import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.Module;

public class SpeleothemBlock
extends QuarkBlock
implements IWaterLoggable {
    public static final EnumProperty<SpeleothemSize> SIZE = EnumProperty.func_177709_a((String)"size", SpeleothemSize.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public SpeleothemBlock(String name, Module module, Block parent, boolean nether) {
        super(name + "_speleothem", module, ItemGroup.field_78031_c, AbstractBlock.Properties.func_200950_a((AbstractBlock)parent).func_200943_b(nether ? 0.4f : 1.5f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(SIZE, (Comparable)((Object)SpeleothemSize.BIG))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return this.getBearing(worldIn, pos) > 0;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        SpeleothemSize size = SpeleothemSize.values()[Math.max(0, this.getBearing((IWorldReader)context.func_195991_k(), context.func_195995_a()) - 1)];
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(SIZE, (Comparable)((Object)size))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        int size = ((SpeleothemSize)((Object)state.func_177229_b(SpeleothemBlock.SIZE))).strength;
        if (this.getBearing((IWorldReader)worldIn, pos) < size + 1) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, PathType type) {
        return type == PathType.WATER && worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    private int getBearing(IWorldReader world, BlockPos pos) {
        return Math.max(this.getStrength(world, pos.func_177977_b()), this.getStrength(world, pos.func_177984_a()));
    }

    private int getStrength(IWorldReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_200132_m()) {
            return 3;
        }
        if (state.func_206871_b().containsKey(SIZE)) {
            return ((SpeleothemSize)((Object)state.func_177229_b(SpeleothemBlock.SIZE))).strength;
        }
        return 0;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ((SpeleothemSize)((Object)state.func_177229_b(SpeleothemBlock.SIZE))).shape;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SIZE, WATERLOGGED});
    }

    public static enum SpeleothemSize implements IStringSerializable
    {
        SMALL(0, 2),
        MEDIUM(1, 4),
        BIG(2, 8);

        public final int strength;
        public final VoxelShape shape;

        private SpeleothemSize(int strength, int width) {
            this.strength = strength;
            int pad = (16 - width) / 2;
            this.shape = Block.func_208617_a((double)pad, (double)0.0, (double)pad, (double)(16 - pad), (double)16.0, (double)(16 - pad));
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

