/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.gen;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;
import vazkii.quark.world.block.RootBlock;
import vazkii.quark.world.module.CaveRootsModule;

public class CaveRootGenerator
extends Generator {
    public CaveRootGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    @Override
    public void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, Random rand, BlockPos corner) {
        for (int i = 0; i < CaveRootsModule.chunkAttempts; ++i) {
            int x = rand.nextInt(12) + 2;
            int z = rand.nextInt(12) + 2;
            int y = rand.nextInt(CaveRootsModule.maxY - CaveRootsModule.minY) + CaveRootsModule.minY;
            BlockPos pos = corner.func_177982_a(x, y, z);
            if (!worldIn.func_175623_d(pos)) continue;
            for (Direction facing : MiscUtil.HORIZONTALS) {
                BlockPos target = pos.func_177972_a(facing);
                if (!RootBlock.isAcceptableNeighbor((IWorld)worldIn, target, facing.func_176734_d())) continue;
                BlockState state = (BlockState)CaveRootsModule.root.func_176223_P().func_206870_a((Property)RootBlock.func_176267_a((Direction)facing), (Comparable)Boolean.valueOf(true));
                worldIn.func_180501_a(pos, state, 2);
                RootBlock.growMany((IWorld)worldIn, rand, pos, state, 0.4f);
            }
        }
    }
}

