/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.gen;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraftforge.common.Tags;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;
import vazkii.quark.world.module.FairyRingsModule;

public class FairyRingGenerator
extends Generator {
    public FairyRingGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    @Override
    public void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, Random rand, BlockPos corner) {
        int x = corner.func_177958_n() + rand.nextInt(16);
        int z = corner.func_177952_p() + rand.nextInt(16);
        BlockPos center = new BlockPos(x, 128, z);
        Biome biome = this.getBiome((IWorld)worldIn, center);
        Biome.Category category = biome.func_201856_r();
        double chance = 0.0;
        if (category == Biome.Category.FOREST) {
            chance = FairyRingsModule.forestChance;
        } else if (category == Biome.Category.PLAINS) {
            chance = FairyRingsModule.plainsChance;
        }
        if (rand.nextDouble() < chance) {
            BlockPos pos = center;
            BlockState state = worldIn.func_180495_p(pos);
            while (state.func_185904_a() != Material.field_151577_b && pos.func_177956_o() > 30) {
                pos = pos.func_177977_b();
                state = worldIn.func_180495_p(pos);
            }
            if (state.func_185904_a() == Material.field_151577_b) {
                FairyRingGenerator.spawnFairyRing((IWorld)worldIn, pos.func_177977_b(), rand);
            }
        }
    }

    public static void spawnFairyRing(IWorld world, BlockPos pos, Random rand) {
        BlockState flower = Blocks.field_196616_bl.func_176223_P();
        for (int i = -3; i <= 3; ++i) {
            block1: for (int j = -3; j <= 3; ++j) {
                float dist = i * i + j * j;
                if (dist < 7.0f || dist > 10.0f) continue;
                for (int k = 5; k > -4; --k) {
                    BlockPos fpos = pos.func_177982_a(i, k, j);
                    BlockPos fposUp = fpos.func_177984_a();
                    BlockState state = world.func_180495_p(fpos);
                    if (state.func_185904_a() != Material.field_151577_b || !world.func_175623_d(fposUp)) continue;
                    world.func_180501_a(fpos.func_177984_a(), flower, 2);
                    continue block1;
                }
            }
        }
        BlockPos orePos = pos.func_177979_c(rand.nextInt(10) + 25);
        BlockState stoneState = world.func_180495_p(orePos);
        for (int down = 0; !stoneState.func_177230_c().func_203417_a((ITag)Tags.Blocks.STONE) && down < 10; ++down) {
            orePos = orePos.func_177977_b();
            stoneState = world.func_180495_p(orePos);
        }
        if (stoneState.func_177230_c().func_203417_a((ITag)Tags.Blocks.STONE)) {
            BlockState ore = FairyRingsModule.ores.get(rand.nextInt(FairyRingsModule.ores.size()));
            world.func_180501_a(orePos, ore, 2);
            for (Direction face : Direction.values()) {
                if (!rand.nextBoolean()) continue;
                world.func_180501_a(orePos.func_177972_a(face), ore, 2);
            }
        }
    }
}

