/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.gen;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import vazkii.quark.base.world.config.ClusterSizeConfig;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.multichunk.ClusterBasedGenerator;

public class UndergroundSpaceGenerator
extends ClusterBasedGenerator {
    public UndergroundSpaceGenerator(DimensionConfig dimConfig, ClusterSizeConfig sizeConfig, long seedXor) {
        super(dimConfig, sizeConfig, seedXor);
    }

    @Override
    public ClusterBasedGenerator.IGenerationContext createContext(BlockPos src, ChunkGenerator generator, Random random, BlockPos chunkCorner, WorldGenRegion world) {
        return (pos, caveNoise) -> {
            BlockState state = world.func_180495_p(pos);
            if (state.func_185887_b((IBlockReader)world, pos) > -1.0f || state.func_185904_a() == Material.field_151587_i) {
                if (pos.func_177956_o() < 6) {
                    world.func_180501_a(pos, Blocks.field_150353_l.func_176223_P(), 1);
                } else if (UndergroundSpaceGenerator.noWaterNeighbor(pos, world)) {
                    world.func_180501_a(pos, Blocks.field_201941_jj.func_176223_P(), 2);
                    if (caveNoise < 0.06) {
                        UndergroundSpaceGenerator.removeInvalidBlocksAndEncloseLava(pos, world, state);
                    }
                }
            }
        };
    }

    private static void removeInvalidBlocksAndEncloseLava(BlockPos src, WorldGenRegion world, BlockState state) {
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)src);
        for (Direction direction : Direction.values()) {
            mutable.func_189533_g((Vector3i)src).func_189536_c(direction);
            if (direction == Direction.UP || direction == Direction.DOWN) {
                while (mutable.func_177956_o() < world.func_217301_I() && mutable.func_177956_o() > 0 && !world.func_180495_p((BlockPos)mutable).func_196955_c((IWorldReader)world, (BlockPos)mutable)) {
                    world.func_180501_a((BlockPos)mutable, Blocks.field_201941_jj.func_176223_P(), 2);
                    mutable.func_189536_c(direction);
                }
            } else if (!world.func_180495_p((BlockPos)mutable).func_196955_c((IWorldReader)world, (BlockPos)mutable)) {
                world.func_180501_a((BlockPos)mutable, Blocks.field_201941_jj.func_176223_P(), 2);
            }
            if (direction == Direction.DOWN) continue;
            mutable.func_189533_g((Vector3i)src).func_189536_c(direction);
            BlockState neighborBlock = world.func_180495_p((BlockPos)mutable);
            if (neighborBlock.func_185904_a() != Material.field_151587_i) continue;
            world.func_180501_a((BlockPos)mutable, state, 3);
        }
    }

    private static boolean noWaterNeighbor(BlockPos src, WorldGenRegion world) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            BlockState neighborBlock;
            if (direction == Direction.DOWN || (neighborBlock = world.func_180495_p((BlockPos)mutable.func_189533_g((Vector3i)src).func_189536_c(direction))).func_185904_a() != Material.field_151586_h || mutable.func_177956_o() <= world.func_205770_a(Heightmap.Type.OCEAN_FLOOR, (BlockPos)mutable).func_177956_o() - 2) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockPos[] getSourcesInChunk(WorldGenRegion world, Random random, ChunkGenerator generator, BlockPos chunkLeft) {
        int rarity;
        if (!(generator instanceof FlatChunkGenerator) && (rarity = this.shapeProvider.getRarity()) > 0 && random.nextInt(rarity) == 0) {
            BlockPos pos = chunkLeft.func_177982_a(random.nextInt(16), this.shapeProvider.getRandomYLevel(random), random.nextInt(16));
            if (this.shapeProvider.getBiomeTypes().canSpawn(this.getBiome((IWorld)world, pos))) {
                return new BlockPos[]{pos};
            }
        }
        return new BlockPos[0];
    }
}

